/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.manager;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.api.event.EntityEmoteEvent;
import dev.geco.gsit.api.event.EntityStopEmoteEvent;
import dev.geco.gsit.api.event.PreEntityEmoteEvent;
import dev.geco.gsit.api.event.PreEntityStopEmoteEvent;
import dev.geco.gsit.manager.IEmoteManager;
import dev.geco.gsit.objects.GEmote;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class EmoteManager
implements IEmoteManager {
    private final GSitMain GPM;
    private int feature_used = 0;
    private final List<GEmote> available_emotes = new ArrayList<GEmote>();
    private final HashMap<LivingEntity, GEmote> emotes = new HashMap();

    public EmoteManager(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @Override
    public int getFeatureUsedCount() {
        return this.feature_used;
    }

    @Override
    public void resetFeatureUsedCount() {
        this.feature_used = 0;
    }

    @Override
    public List<GEmote> getAvailableEmotes() {
        return new ArrayList<GEmote>(this.available_emotes);
    }

    @Override
    public GEmote getEmoteByName(String Name) {
        return this.available_emotes.stream().filter(e -> e.getId().equalsIgnoreCase(Name)).findFirst().orElse(null);
    }

    @Override
    public List<GEmote> reloadEmotes() {
        this.clearEmotes();
        this.available_emotes.clear();
        try {
            File directory = new File("plugins/" + this.GPM.NAME + "/" + "emotes");
            if (!directory.exists()) {
                return this.getAvailableEmotes();
            }
            for (File emoteFile : directory.listFiles()) {
                String fileName = emoteFile.getName().toLowerCase();
                if (!fileName.endsWith(".gex")) continue;
                this.available_emotes.add(this.GPM.getEmoteUtil().createEmoteFromRawData(emoteFile));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getAvailableEmotes();
    }

    @Override
    public HashMap<LivingEntity, GEmote> getEmotes() {
        return new HashMap<LivingEntity, GEmote>(this.emotes);
    }

    @Override
    public boolean isEmoting(LivingEntity Entity2) {
        return this.getEmote(Entity2) != null;
    }

    @Override
    public GEmote getEmote(LivingEntity Entity2) {
        for (Map.Entry<LivingEntity, GEmote> emote : this.getEmotes().entrySet()) {
            if (!Entity2.equals(emote.getKey())) continue;
            return emote.getValue();
        }
        return null;
    }

    @Override
    public void clearEmotes() {
        for (LivingEntity entity : this.getEmotes().keySet()) {
            this.stopEmote(entity);
        }
    }

    @Override
    public boolean startEmote(LivingEntity Entity2, GEmote Emote) {
        PreEntityEmoteEvent preEvent = new PreEntityEmoteEvent(Entity2, Emote);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return false;
        }
        if (!this.available_emotes.contains(Emote) || Emote.getParts().size() == 0) {
            return false;
        }
        if (!this.stopEmote(Entity2)) {
            return false;
        }
        Emote.start(Entity2);
        this.emotes.put(Entity2, Emote);
        ++this.feature_used;
        Bukkit.getPluginManager().callEvent((Event)new EntityEmoteEvent(Entity2, Emote));
        return true;
    }

    @Override
    public boolean stopEmote(LivingEntity Entity2) {
        if (!this.isEmoting(Entity2)) {
            return true;
        }
        GEmote emote = this.getEmote(Entity2);
        PreEntityStopEmoteEvent preEvent = new PreEntityStopEmoteEvent(Entity2, emote);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return false;
        }
        emote.stop((Entity)Entity2);
        this.emotes.remove(Entity2);
        Bukkit.getPluginManager().callEvent((Event)new EntityStopEmoteEvent(Entity2, emote));
        return true;
    }
}

