/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.events;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.GetUpReason;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.spigotmc.event.entity.EntityDismountEvent;

public class PlayerSitEvents
implements Listener {
    private final GSitMain GPM;

    public PlayerSitEvents(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void PTogSE(PlayerToggleSneakEvent Event) {
        Player player = Event.getPlayer();
        if (!this.GPM.getCManager().PS_SNEAK_EJECTS || !Event.isSneaking() || player.isFlying() || player.isInsideVehicle()) {
            return;
        }
        if (!this.GPM.getPlayerSitManager().stopPlayerSit((Entity)player, GetUpReason.KICKED)) {
            Event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PDeaE(PlayerDeathEvent Event) {
        if (Event.getEntity().isInsideVehicle()) {
            this.GPM.getPlayerSitManager().stopPlayerSit((Entity)Event.getEntity(), GetUpReason.DEATH);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PQuiE(PlayerQuitEvent Event) {
        if (Event.getPlayer().isInsideVehicle()) {
            this.GPM.getPlayerSitManager().stopPlayerSit((Entity)Event.getPlayer(), GetUpReason.QUIT);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void EDisE(EntityDismountEvent Event) {
        if (!this.GPM.getPlayerSitManager().stopPlayerSit(Event.getEntity(), GetUpReason.GET_UP)) {
            Event.setCancelled(true);
        }
        this.GPM.getPlayerSitManager().stopPlayerSit(Event.getDismounted(), GetUpReason.GET_UP);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void PIntAEE(PlayerInteractAtEntityEvent Event) {
        Entity rightClicked = Event.getRightClicked();
        if (!(rightClicked instanceof Player)) {
            return;
        }
        Player player = Event.getPlayer();
        Player target = (Player)rightClicked;
        if (!this.GPM.getCManager().PS_ALLOW_SIT && !this.GPM.getCManager().PS_ALLOW_SIT_NPC) {
            return;
        }
        if (!this.GPM.getPManager().hasPermission((CommandSender)player, "PlayerSit")) {
            return;
        }
        if (this.GPM.getCManager().WORLDBLACKLIST.contains(player.getWorld().getName()) && !this.GPM.getPManager().hasPermission((CommandSender)player, "ByPass.World", "ByPass.*")) {
            return;
        }
        if (this.GPM.getCManager().PS_EMPTY_HAND_ONLY && player.getInventory().getItemInMainHand().getType() != Material.AIR) {
            return;
        }
        if (!player.isValid() || !target.isValid() || player.isSneaking() || player.isInsideVehicle() || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (this.GPM.getCrawlManager() != null && this.GPM.getCrawlManager().isCrawling(player)) {
            return;
        }
        double distance = this.GPM.getCManager().PS_MAX_DISTANCE;
        if (distance > 0.0 && target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0).distance(player.getLocation().add(0.0, player.getHeight() / 2.0, 0.0)) > distance) {
            return;
        }
        if (this.GPM.getPlotSquaredLink() != null && !this.GPM.getPlotSquaredLink().canCreateSeat(target.getLocation(), player)) {
            return;
        }
        if (this.GPM.getWorldGuardLink() != null && !this.GPM.getWorldGuardLink().checkFlag(target.getLocation(), this.GPM.getWorldGuardLink().getFlag("playersit"))) {
            return;
        }
        if (this.GPM.getGriefPreventionLink() != null && !this.GPM.getGriefPreventionLink().check(target.getLocation(), player)) {
            return;
        }
        if (this.GPM.getPassengerUtil().isInPassengerList((Entity)target, (Entity)player) || this.GPM.getPassengerUtil().isInPassengerList((Entity)player, (Entity)target)) {
            return;
        }
        long amount = this.GPM.getPassengerUtil().getPassengerAmount((Entity)target) + 1L + this.GPM.getPassengerUtil().getVehicleAmount((Entity)target) + this.GPM.getPassengerUtil().getPassengerAmount((Entity)player);
        if (this.GPM.getCManager().PS_MAX_STACK > 0L && this.GPM.getCManager().PS_MAX_STACK <= amount) {
            return;
        }
        Entity highestEntity = this.GPM.getPassengerUtil().getHighestEntity((Entity)target);
        if (!(highestEntity instanceof Player)) {
            return;
        }
        Player highestPlayer = (Player)highestEntity;
        if (!this.GPM.getToggleManager().canPlayerSit(player.getUniqueId()) || !this.GPM.getToggleManager().canPlayerSit(highestPlayer.getUniqueId())) {
            return;
        }
        boolean isNPC = this.GPM.getPassengerUtil().isNPC(highestPlayer);
        if (isNPC && !this.GPM.getCManager().PS_ALLOW_SIT_NPC) {
            return;
        }
        if (!isNPC && !this.GPM.getCManager().PS_ALLOW_SIT) {
            return;
        }
        boolean cancel = this.GPM.getPlayerSitManager().sitOnPlayer(player, highestPlayer);
        if (cancel) {
            Event.setCancelled(true);
        }
    }
}

