/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.events;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.GetUpReason;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.spigotmc.event.entity.EntityDismountEvent;

public class PlayerEvents
implements Listener {
    private final GSitMain GPM;
    private final double MAX_DOUBLE_SNEAK_PITCH = 85.0;
    private final long MAX_DOUBLE_SNEAK_TIME = 400L;
    private final HashMap<Player, Long> crawlPlayers = new HashMap();

    public PlayerEvents(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @EventHandler
    public void PJoiE(PlayerJoinEvent Event) {
        Player player = Event.getPlayer();
        if (this.GPM.getCManager().CHECK_FOR_UPDATES && !this.GPM.getUManager().isLatestVersion()) {
            String message = this.GPM.getMManager().getMessage("Plugin.plugin-update", "%Name%", this.GPM.NAME, "%NewVersion%", this.GPM.getUManager().getLatestVersion(), "%Version%", this.GPM.getUManager().getPluginVersion(), "%Path%", this.GPM.getDescription().getWebsite());
            if (this.GPM.getPManager().hasPermission((CommandSender)player, "Update")) {
                player.sendMessage(message);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PQuiE(PlayerQuitEvent Event) {
        Player player = Event.getPlayer();
        if (this.GPM.getSitManager().isSitting((LivingEntity)player)) {
            this.GPM.getSitManager().removeSeat((LivingEntity)player, GetUpReason.QUIT, true);
        }
        if (this.GPM.getPoseManager() != null && this.GPM.getPoseManager().isPosing(player)) {
            this.GPM.getPoseManager().removePose(player, GetUpReason.QUIT, true);
        }
        if (this.GPM.getCrawlManager() != null && this.GPM.getCrawlManager().isCrawling(player)) {
            this.GPM.getCrawlManager().stopCrawl(player, GetUpReason.QUIT);
        }
        this.crawlPlayers.remove(player);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void PTelE(PlayerTeleportEvent Event) {
        Player player = Event.getPlayer();
        if (this.GPM.getSitManager().isSitting((LivingEntity)player) && !this.GPM.getSitManager().removeSeat((LivingEntity)player, GetUpReason.TELEPORT, false)) {
            Event.setCancelled(true);
        }
        if (this.GPM.getPoseManager() != null && this.GPM.getPoseManager().isPosing(player) && !this.GPM.getPoseManager().removePose(player, GetUpReason.TELEPORT, false)) {
            Event.setCancelled(true);
        }
        if (this.GPM.getCrawlManager() != null && this.GPM.getCrawlManager().isCrawling(player) && !this.GPM.getCrawlManager().stopCrawl(player, GetUpReason.TELEPORT)) {
            Event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void EDisE(EntityDismountEvent Event) {
        Entity entity = Event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.GPM.getSitManager().isSitting((LivingEntity)player)) {
            if (!this.GPM.getCManager().GET_UP_SNEAK) {
                Event.setCancelled(true);
            } else if (!this.GPM.getSitManager().removeSeat((LivingEntity)player, GetUpReason.GET_UP, true)) {
                Event.setCancelled(true);
            }
        }
        if (this.GPM.getPoseManager() != null && this.GPM.getPoseManager().isPosing(player)) {
            if (!this.GPM.getCManager().GET_UP_SNEAK) {
                Event.setCancelled(true);
            } else if (!this.GPM.getPoseManager().removePose(player, GetUpReason.GET_UP, true)) {
                Event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void EDamE(EntityDamageEvent Event) {
        Entity entity = Event.getEntity();
        if (!this.GPM.getCManager().GET_UP_DAMAGE || !(entity instanceof Player) || Event.getFinalDamage() <= 0.0) {
            return;
        }
        Player player = (Player)entity;
        if (this.GPM.getSitManager().isSitting((LivingEntity)player)) {
            this.GPM.getSitManager().removeSeat((LivingEntity)player, GetUpReason.DAMAGE, true);
        }
        if (this.GPM.getPoseManager() != null && this.GPM.getPoseManager().isPosing(player)) {
            this.GPM.getPoseManager().removePose(player, GetUpReason.DAMAGE, true);
        }
        if (this.GPM.getCrawlManager() != null && this.GPM.getCrawlManager().isCrawling(player)) {
            this.GPM.getCrawlManager().stopCrawl(player, GetUpReason.DAMAGE);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void PComPE(PlayerCommandPreprocessEvent Event) {
        Player player = Event.getPlayer();
        String message = Event.getMessage();
        if (message.length() > 1 && (this.GPM.getSitManager().isSitting((LivingEntity)player) || this.GPM.getPoseManager() != null && this.GPM.getPoseManager().isPosing(player))) {
            message = message.substring(1).split(" ")[0].toLowerCase();
            if (this.GPM.getCManager().COMMANDBLACKLIST.stream().anyMatch(message::equalsIgnoreCase)) {
                this.GPM.getMManager().sendMessage((CommandSender)player, "Messages.action-blocked-error", new Object[0]);
                Event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void PTogSE(PlayerToggleSneakEvent Event) {
        Player player = Event.getPlayer();
        if (!this.GPM.getCManager().C_DOUBLE_SNEAK) {
            return;
        }
        if (!Event.isSneaking() || (double)player.getLocation().getPitch() < 85.0 || this.GPM.getCrawlManager() == null) {
            return;
        }
        if (!player.isValid() || !player.isOnGround() || player.isInsideVehicle() || player.isSleeping() || this.GPM.getCrawlManager().isCrawling(player)) {
            return;
        }
        if (!this.crawlPlayers.containsKey(player)) {
            this.crawlPlayers.put(player, System.currentTimeMillis());
            return;
        }
        long last = this.crawlPlayers.get(player);
        this.crawlPlayers.put(player, System.currentTimeMillis());
        if (last >= System.currentTimeMillis() - 400L) {
            if (!this.GPM.getPManager().hasPermission((CommandSender)player, "Crawl")) {
                return;
            }
            if (!this.GPM.getPManager().hasPermission((CommandSender)player, "ByPass.Region", "ByPass.*") && this.GPM.getCManager().WORLDBLACKLIST.contains(player.getWorld().getName()) && !this.GPM.getPManager().hasPermission((CommandSender)player, "ByPass.World", "ByPass.*")) {
                return;
            }
            if (this.GPM.getWorldGuardLink() != null && !this.GPM.getWorldGuardLink().checkFlag(player.getLocation(), this.GPM.getWorldGuardLink().getFlag("crawl"))) {
                return;
            }
            if (this.GPM.getCrawlManager().startCrawl(player) == null) {
                this.crawlPlayers.remove(player);
            }
        }
    }
}

