/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.events;

import dev.geco.gsit.GSitMain;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class InteractEvents
implements Listener {
    private final GSitMain GPM;

    public InteractEvents(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void PIntE(PlayerInteractEvent Event) {
        Block clickedBlock = Event.getClickedBlock();
        Action action = Event.getAction();
        Player player = Event.getPlayer();
        if (Event.getHand() != EquipmentSlot.HAND || action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (Event.getBlockFace() != BlockFace.UP) {
            return;
        }
        if (this.GPM.getCManager().S_EMPTY_HAND_ONLY && Event.getItem() != null) {
            return;
        }
        if (clickedBlock == null || !this.GPM.getPManager().hasPermission((CommandSender)player, "SitClick")) {
            return;
        }
        if (!this.GPM.getCManager().S_SITMATERIALS.containsKey(clickedBlock.getType())) {
            return;
        }
        if (this.GPM.getCManager().MATERIALBLACKLIST.contains(clickedBlock.getType())) {
            return;
        }
        if (this.GPM.getCManager().WORLDBLACKLIST.contains(player.getWorld().getName()) && !this.GPM.getPManager().hasPermission((CommandSender)player, "ByPass.World", "ByPass.*")) {
            return;
        }
        if (!player.isValid() || !player.isOnGround() || player.isSneaking() || player.isInsideVehicle()) {
            return;
        }
        if (!this.GPM.getToggleManager().canSit(player.getUniqueId())) {
            return;
        }
        if (this.GPM.getCrawlManager() != null && this.GPM.getCrawlManager().isCrawling(player)) {
            return;
        }
        double distance = this.GPM.getCManager().S_MAX_DISTANCE;
        if (distance > 0.0 && clickedBlock.getLocation().add(0.5, 0.5, 0.5).distance(player.getLocation()) > distance) {
            return;
        }
        if (!this.GPM.getCManager().ALLOW_UNSAFE && !clickedBlock.getRelative(BlockFace.UP).isPassable()) {
            return;
        }
        if (this.GPM.getPlotSquaredLink() != null && !this.GPM.getPlotSquaredLink().canCreatePlayerSeat(clickedBlock.getLocation(), player)) {
            return;
        }
        if (this.GPM.getWorldGuardLink() != null && !this.GPM.getWorldGuardLink().checkFlag(clickedBlock.getLocation(), this.GPM.getWorldGuardLink().getFlag("sit"))) {
            return;
        }
        if (this.GPM.getGriefPreventionLink() != null && !this.GPM.getGriefPreventionLink().check(clickedBlock.getLocation(), player)) {
            return;
        }
        if (!this.GPM.getCManager().SAME_BLOCK_REST && !this.GPM.getSitManager().kickSeat(clickedBlock, (LivingEntity)player)) {
            return;
        }
        if (Tag.STAIRS.isTagged((Keyed)clickedBlock.getType())) {
            if (((Stairs)clickedBlock.getBlockData()).getHalf() != Bisected.Half.BOTTOM) {
                return;
            }
            if (this.GPM.getSitUtil().createSeatForStair(clickedBlock, (LivingEntity)player) != null) {
                Event.setCancelled(true);
                return;
            }
        } else if (Tag.SLABS.isTagged((Keyed)clickedBlock.getType()) && ((Slab)clickedBlock.getBlockData()).getType() != Slab.Type.BOTTOM) {
            return;
        }
        if (this.GPM.getSitManager().createSeat(clickedBlock, (LivingEntity)player, true, 0.0, 0.0, 0.0, player.getLocation().getYaw(), true, this.GPM.getCManager().GET_UP_SNEAK) != null) {
            Event.setCancelled(true);
        }
    }
}

