/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.cmd;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.GetUpReason;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public class GSitCommand
implements CommandExecutor {
    private final GSitMain GPM;

    public GSitCommand(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    public boolean onCommand(@NotNull CommandSender Sender, @NotNull Command Command2, @NotNull String Label, String[] Args) {
        if (!(Sender instanceof Player)) {
            this.GPM.getMManager().sendMessage(Sender, "Messages.command-sender-error", new Object[0]);
            return true;
        }
        Player player = (Player)Sender;
        if (Args.length == 0) {
            Block block;
            if (!this.GPM.getPManager().hasPermission(Sender, "Sit")) {
                this.GPM.getMManager().sendMessage(Sender, "Messages.command-permission-error", new Object[0]);
                return true;
            }
            if (this.GPM.getSitManager().isSitting((LivingEntity)player)) {
                this.GPM.getSitManager().removeSeat((LivingEntity)player, GetUpReason.GET_UP);
                return true;
            }
            if (!player.isValid() || player.isSneaking() || !player.isOnGround() || player.isInsideVehicle() || player.isSleeping()) {
                this.GPM.getMManager().sendMessage(Sender, "Messages.action-sit-now-error", new Object[0]);
                return true;
            }
            if (this.GPM.getCManager().WORLDBLACKLIST.contains(player.getWorld().getName()) && !this.GPM.getPManager().hasPermission(Sender, "ByPass.World", "ByPass.*")) {
                this.GPM.getMManager().sendMessage(Sender, "Messages.action-sit-world-error", new Object[0]);
                return true;
            }
            Location playerLocation = player.getLocation();
            Block block2 = block = playerLocation.getBlock().isPassable() ? playerLocation.subtract(0.0, 0.0625, 0.0).getBlock() : playerLocation.getBlock();
            if (this.GPM.getCManager().MATERIALBLACKLIST.contains(block.getType())) {
                this.GPM.getMManager().sendMessage(Sender, "Messages.action-sit-location-error", new Object[0]);
                return true;
            }
            boolean overSize = false;
            try {
                for (BoundingBox boundingBox : block.getCollisionShape().getBoundingBoxes()) {
                    if (!(boundingBox.getMaxY() > 1.25)) continue;
                    overSize = true;
                }
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
            if (!this.GPM.getCManager().ALLOW_UNSAFE && (!block.getRelative(BlockFace.UP).isPassable() || overSize || block.isPassable() && this.GPM.getCManager().CENTER_BLOCK)) {
                this.GPM.getMManager().sendMessage(Sender, "Messages.action-sit-location-error", new Object[0]);
                return true;
            }
            if (!this.GPM.getPManager().hasPermission(Sender, "ByPass.Region", "ByPass.*")) {
                if (this.GPM.getWorldGuardLink() != null && !this.GPM.getWorldGuardLink().checkFlag(block.getLocation(), this.GPM.getWorldGuardLink().getFlag("sit"))) {
                    this.GPM.getMManager().sendMessage(Sender, "Messages.action-sit-region-error", new Object[0]);
                    return true;
                }
                if (this.GPM.getGriefPreventionLink() != null && !this.GPM.getGriefPreventionLink().check(block.getLocation(), player)) {
                    this.GPM.getMManager().sendMessage(Sender, "Messages.action-sit-region-error", new Object[0]);
                    return true;
                }
                if (this.GPM.getPlotSquaredLink() != null && !this.GPM.getPlotSquaredLink().canCreateSeat(block.getLocation(), player)) {
                    this.GPM.getMManager().sendMessage(Sender, "Messages.action-sit-region-error", new Object[0]);
                    return true;
                }
            }
            if (!this.GPM.getCManager().SAME_BLOCK_REST && !this.GPM.getSitManager().kickSeat(block, (LivingEntity)player)) {
                this.GPM.getMManager().sendMessage(Sender, "Messages.action-sit-kick-error", new Object[0]);
                return true;
            }
            if (Tag.STAIRS.isTagged((Keyed)block.getType()) ? this.GPM.getSitUtil().createSeatForStair(block, (LivingEntity)player) == null : this.GPM.getSitManager().createSeat(block, (LivingEntity)player) == null) {
                this.GPM.getMManager().sendMessage(Sender, "Messages.action-sit-region-error", new Object[0]);
            }
            return true;
        }
        switch (Args[0]) {
            case "toggle": {
                if (this.GPM.getPManager().hasPermission(Sender, "SitToggle") && this.GPM.getCManager().S_SITMATERIALS.size() > 0) {
                    if (this.GPM.getToggleManager().canSit(player.getUniqueId())) {
                        this.GPM.getToggleManager().setCanSit(player.getUniqueId(), false);
                        this.GPM.getMManager().sendMessage(Sender, "Messages.command-gsit-toggle-off", new Object[0]);
                        break;
                    }
                    this.GPM.getToggleManager().setCanSit(player.getUniqueId(), true);
                    this.GPM.getMManager().sendMessage(Sender, "Messages.command-gsit-toggle-on", new Object[0]);
                    break;
                }
            }
            case "playertoggle": {
                if (this.GPM.getPManager().hasPermission(Sender, "PlayerSitToggle") && this.GPM.getCManager().PS_ALLOW_SIT) {
                    if (this.GPM.getToggleManager().canPlayerSit(player.getUniqueId())) {
                        this.GPM.getToggleManager().setCanPlayerSit(player.getUniqueId(), false);
                        this.GPM.getMManager().sendMessage(Sender, "Messages.command-gsit-playertoggle-off", new Object[0]);
                        break;
                    }
                    this.GPM.getToggleManager().setCanPlayerSit(player.getUniqueId(), true);
                    this.GPM.getMManager().sendMessage(Sender, "Messages.command-gsit-playertoggle-on", new Object[0]);
                    break;
                }
            }
            default: {
                Bukkit.dispatchCommand((CommandSender)Sender, (String)Label);
            }
        }
        return true;
    }
}

