/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.cmd;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.GetUpReason;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public class GBellyFlopCommand
implements CommandExecutor {
    private final GSitMain GPM;

    public GBellyFlopCommand(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    public boolean onCommand(@NotNull CommandSender Sender, @NotNull Command Command2, @NotNull String Label, String[] Args) {
        Block block;
        if (!(Sender instanceof Player)) {
            this.GPM.getMManager().sendMessage(Sender, "Messages.command-sender-error", new Object[0]);
            return true;
        }
        Player player = (Player)Sender;
        if (!this.GPM.getPManager().hasPermission(Sender, "BellyFlop")) {
            this.GPM.getMManager().sendMessage(Sender, "Messages.command-permission-error", new Object[0]);
            return true;
        }
        if (this.GPM.getPoseManager() == null) {
            String v = Bukkit.getServer().getClass().getPackage().getName();
            v = v.substring(v.lastIndexOf(46) + 1);
            this.GPM.getMManager().sendMessage(Sender, "Messages.command-version-error", "%Version%", v);
            return true;
        }
        if (this.GPM.getPoseManager().isPosing(player) && this.GPM.getPoseManager().getPose(player).getPose() == Pose.SWIMMING) {
            this.GPM.getPoseManager().removePose(player, GetUpReason.GET_UP);
            return true;
        }
        if (!player.isValid() || player.isSneaking() || !player.isOnGround() || player.isInsideVehicle() || player.isSleeping()) {
            this.GPM.getMManager().sendMessage(Sender, "Messages.action-pose-now-error", new Object[0]);
            return true;
        }
        if (this.GPM.getCManager().WORLDBLACKLIST.contains(player.getWorld().getName()) && !this.GPM.getPManager().hasPermission(Sender, "ByPass.World", "ByPass.*")) {
            this.GPM.getMManager().sendMessage(Sender, "Messages.action-pose-world-error", new Object[0]);
            return true;
        }
        Location playerLocation = player.getLocation();
        Block block2 = block = playerLocation.getBlock().isPassable() ? playerLocation.subtract(0.0, 0.0625, 0.0).getBlock() : playerLocation.getBlock();
        if (this.GPM.getCManager().MATERIALBLACKLIST.contains(block.getType())) {
            this.GPM.getMManager().sendMessage(Sender, "Messages.action-pose-location-error", new Object[0]);
            return true;
        }
        boolean overSize = false;
        try {
            for (BoundingBox boundingBox : block.getCollisionShape().getBoundingBoxes()) {
                if (!(boundingBox.getMaxY() > 1.25)) continue;
                overSize = true;
            }
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        if (!this.GPM.getCManager().ALLOW_UNSAFE && (!block.getRelative(BlockFace.UP).isPassable() || overSize || block.isPassable() && this.GPM.getCManager().CENTER_BLOCK)) {
            this.GPM.getMManager().sendMessage(Sender, "Messages.action-pose-location-error", new Object[0]);
            return true;
        }
        if (!this.GPM.getPManager().hasPermission(Sender, "ByPass.Region", "ByPass.*")) {
            if (this.GPM.getWorldGuardLink() != null && !this.GPM.getWorldGuardLink().checkFlag(block.getLocation(), this.GPM.getWorldGuardLink().getFlag("pose"))) {
                this.GPM.getMManager().sendMessage(Sender, "Messages.action-pose-region-error", new Object[0]);
                return true;
            }
            if (this.GPM.getGriefPreventionLink() != null && !this.GPM.getGriefPreventionLink().check(block.getLocation(), player)) {
                this.GPM.getMManager().sendMessage(Sender, "Messages.action-pose-region-error", new Object[0]);
                return true;
            }
            if (this.GPM.getPlotSquaredLink() != null && !this.GPM.getPlotSquaredLink().canCreateSeat(block.getLocation(), player)) {
                this.GPM.getMManager().sendMessage(Sender, "Messages.action-pose-region-error", new Object[0]);
                return true;
            }
        }
        if (!this.GPM.getCManager().SAME_BLOCK_REST && !this.GPM.getPoseManager().kickPose(block, player)) {
            this.GPM.getMManager().sendMessage(Sender, "Messages.action-pose-kick-error", new Object[0]);
            return true;
        }
        if (this.GPM.getPoseManager().createPose(block, player, Pose.SWIMMING) == null) {
            this.GPM.getMManager().sendMessage(Sender, "Messages.action-pose-region-error", new Object[0]);
        }
        return true;
    }
}

