/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit;

import dev.geco.gsit.cmd.GBellyFlopCommand;
import dev.geco.gsit.cmd.GCrawlCommand;
import dev.geco.gsit.cmd.GEmoteCommand;
import dev.geco.gsit.cmd.GLayCommand;
import dev.geco.gsit.cmd.GSitCommand;
import dev.geco.gsit.cmd.GSitReloadCommand;
import dev.geco.gsit.cmd.GSpinCommand;
import dev.geco.gsit.cmd.tab.EmptyTabComplete;
import dev.geco.gsit.cmd.tab.GCrawlTabComplete;
import dev.geco.gsit.cmd.tab.GEmoteTabComplete;
import dev.geco.gsit.cmd.tab.GSitTabComplete;
import dev.geco.gsit.events.BlockEvents;
import dev.geco.gsit.events.InteractEvents;
import dev.geco.gsit.events.PlayerEvents;
import dev.geco.gsit.events.PlayerSitEvents;
import dev.geco.gsit.link.BStatsLink;
import dev.geco.gsit.link.GriefPreventionLink;
import dev.geco.gsit.link.PlaceholderAPILink;
import dev.geco.gsit.link.PlotSquaredLink;
import dev.geco.gsit.link.WorldGuardLink;
import dev.geco.gsit.manager.CManager;
import dev.geco.gsit.manager.EmoteManager;
import dev.geco.gsit.manager.ICrawlManager;
import dev.geco.gsit.manager.IEmoteManager;
import dev.geco.gsit.manager.IPlayerSitManager;
import dev.geco.gsit.manager.IPoseManager;
import dev.geco.gsit.manager.ISitManager;
import dev.geco.gsit.manager.MManager;
import dev.geco.gsit.manager.NMSManager;
import dev.geco.gsit.manager.PManager;
import dev.geco.gsit.manager.PlayerSitManager;
import dev.geco.gsit.manager.SitManager;
import dev.geco.gsit.manager.ToggleManager;
import dev.geco.gsit.manager.UManager;
import dev.geco.gsit.util.EmoteUtil;
import dev.geco.gsit.util.ISpawnUtil;
import dev.geco.gsit.util.ITeleportUtil;
import dev.geco.gsit.util.PassengerUtil;
import dev.geco.gsit.util.PoseUtil;
import dev.geco.gsit.util.SitUtil;
import dev.geco.gsit.util.SpawnUtil;
import dev.geco.gsit.util.TeleportUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GSitMain
extends JavaPlugin {
    private FileConfiguration messages;
    private CManager cManager;
    private String prefix;
    private ISitManager sitManager;
    private IPoseManager poseManager;
    private IPlayerSitManager playerSitManager;
    private ICrawlManager crawlManager;
    private IEmoteManager emoteManager;
    private ToggleManager toggleManager;
    private UManager uManager;
    private PManager pManager;
    private MManager mManager;
    private EmoteUtil emoteUtil;
    private PassengerUtil passengerUtil;
    private SitUtil sitUtil;
    private PoseUtil poseUtil;
    private ISpawnUtil spawnUtil;
    private ITeleportUtil teleportUtil;
    private WorldGuardLink worldGuardLink;
    private PlaceholderAPILink placeholderAPILink;
    private GriefPreventionLink griefPreventionLink;
    private PlotSquaredLink plotSquaredLink;
    public final int SERVER = Bukkit.getVersion().contains("Paper") ? 2 : (Bukkit.getVersion().contains("Spigot") ? 1 : (Bukkit.getVersion().contains("Bukkit") ? 0 : 3));
    public final String NAME = "GSit";
    public final String RESOURCE = "62325";
    private final List<String> LANGS = new ArrayList<String>();
    private final List<String> EMOTES;
    private static GSitMain GPM;

    public GSitMain() {
        this.LANGS.add("de_de");
        this.LANGS.add("en_en");
        this.LANGS.add("es_es");
        this.LANGS.add("fi_fi");
        this.LANGS.add("fr_fr");
        this.LANGS.add("it_it");
        this.LANGS.add("ja_jp");
        this.LANGS.add("pl_pl");
        this.LANGS.add("pt_br");
        this.LANGS.add("ru_ru");
        this.LANGS.add("uk_ua");
        this.LANGS.add("zh_cn");
        this.LANGS.add("zh_tw");
        this.EMOTES = new ArrayList<String>();
    }

    public FileConfiguration getMessages() {
        return this.messages;
    }

    public CManager getCManager() {
        return this.cManager;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ISitManager getSitManager() {
        return this.sitManager;
    }

    public IPoseManager getPoseManager() {
        return this.poseManager;
    }

    public IPlayerSitManager getPlayerSitManager() {
        return this.playerSitManager;
    }

    public ICrawlManager getCrawlManager() {
        return this.crawlManager;
    }

    public IEmoteManager getEmoteManager() {
        return this.emoteManager;
    }

    public ToggleManager getToggleManager() {
        return this.toggleManager;
    }

    public UManager getUManager() {
        return this.uManager;
    }

    public PManager getPManager() {
        return this.pManager;
    }

    public MManager getMManager() {
        return this.mManager;
    }

    public EmoteUtil getEmoteUtil() {
        return this.emoteUtil;
    }

    public PassengerUtil getPassengerUtil() {
        return this.passengerUtil;
    }

    public SitUtil getSitUtil() {
        return this.sitUtil;
    }

    public PoseUtil getPoseUtil() {
        return this.poseUtil;
    }

    public ISpawnUtil getSpawnUtil() {
        return this.spawnUtil;
    }

    public ITeleportUtil getPlayerUtil() {
        return this.teleportUtil;
    }

    public WorldGuardLink getWorldGuardLink() {
        return this.worldGuardLink;
    }

    public PlaceholderAPILink getPlaceholderAPILink() {
        return this.placeholderAPILink;
    }

    public GriefPreventionLink getGriefPreventionLink() {
        return this.griefPreventionLink;
    }

    public PlotSquaredLink getPlotSquaredLink() {
        return this.plotSquaredLink;
    }

    public static GSitMain getInstance() {
        return GPM;
    }

    private void loadSettings() {
        this.copyLangFiles();
        this.copyEmoteFiles();
        this.messages = YamlConfiguration.loadConfiguration((File)new File("plugins/GSit/lang", this.getConfig().getString("Lang.lang", "en_en") + ".yml"));
        this.prefix = this.getMessages().getString("Plugin.plugin-prefix", "[GSit]");
        this.getEmoteManager().reloadEmotes();
        this.getToggleManager().loadToggleData();
    }

    private void linkBStats() {
        BStatsLink bstats = new BStatsLink(GSitMain.getInstance(), 4914);
        bstats.addCustomChart(new BStatsLink.SimplePie("plugin_language", () -> this.getConfig().getString("Lang.lang", "en_en").toLowerCase()));
        bstats.addCustomChart(new BStatsLink.SingleLineChart("use_sit_feature", () -> {
            int count = this.getSitManager().getFeatureUsedCount();
            this.getSitManager().resetFeatureUsedCount();
            return count;
        }));
        bstats.addCustomChart(new BStatsLink.SingleLineChart("use_pose_feature", () -> {
            if (this.getPoseManager() == null) {
                return 0;
            }
            int count = this.getPoseManager().getFeatureUsedCount();
            this.getPoseManager().resetFeatureUsedCount();
            return count;
        }));
        bstats.addCustomChart(new BStatsLink.SingleLineChart("use_psit_feature", () -> {
            int count = this.getPlayerSitManager().getFeatureUsedCount();
            this.getPlayerSitManager().resetFeatureUsedCount();
            return count;
        }));
        bstats.addCustomChart(new BStatsLink.SingleLineChart("use_crawl_feature", () -> {
            if (this.getCrawlManager() == null) {
                return 0;
            }
            int count = this.getCrawlManager().getFeatureUsedCount();
            this.getCrawlManager().resetFeatureUsedCount();
            return count;
        }));
        bstats.addCustomChart(new BStatsLink.SingleLineChart("use_emote_feature", () -> {
            int count = this.getEmoteManager().getFeatureUsedCount();
            this.getEmoteManager().resetFeatureUsedCount();
            return count;
        }));
    }

    public void onLoad() {
        GPM = this;
        this.saveDefaultConfig();
        this.cManager = new CManager(GSitMain.getInstance());
        this.uManager = new UManager((Plugin)GSitMain.getInstance(), "62325");
        this.pManager = new PManager(GSitMain.getInstance());
        this.mManager = new MManager(GSitMain.getInstance());
        this.sitManager = new SitManager(GSitMain.getInstance());
        this.playerSitManager = new PlayerSitManager(GSitMain.getInstance());
        this.emoteManager = new EmoteManager(GSitMain.getInstance());
        this.toggleManager = new ToggleManager(GSitMain.getInstance());
        this.emoteUtil = new EmoteUtil();
        this.passengerUtil = new PassengerUtil(GSitMain.getInstance());
        this.sitUtil = new SitUtil(GSitMain.getInstance());
        this.poseUtil = new PoseUtil(GSitMain.getInstance());
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            this.worldGuardLink = new WorldGuardLink(GSitMain.getInstance());
            this.worldGuardLink.registerFlags();
        }
    }

    public void onEnable() {
        this.loadSettings();
        if (!this.versionCheck()) {
            return;
        }
        this.poseManager = NMSManager.isNewerOrVersion(17L, 0) ? (IPoseManager)NMSManager.getPackageObject("gsit", "manager.PoseManager", (Object)GSitMain.getInstance()) : null;
        this.crawlManager = NMSManager.isNewerOrVersion(17L, 0) ? (ICrawlManager)NMSManager.getPackageObject("gsit", "manager.CrawlManager", (Object)GSitMain.getInstance()) : null;
        this.spawnUtil = NMSManager.isNewerOrVersion(17L, 0) ? (ISpawnUtil)NMSManager.getPackageObject("gsit", "util.SpawnUtil", null) : new SpawnUtil();
        this.teleportUtil = NMSManager.isNewerOrVersion(17L, 0) ? (ITeleportUtil)NMSManager.getPackageObject("gsit", "util.TeleportUtil", null) : new TeleportUtil();
        this.setupCommands();
        this.setupEvents();
        this.linkBStats();
        this.getMManager().sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-enabled", new Object[0]);
        this.loadPluginDepends((CommandSender)Bukkit.getConsoleSender());
        this.checkForUpdates();
    }

    public void onDisable() {
        this.getSitManager().clearSeats();
        if (this.getPoseManager() != null) {
            this.getPoseManager().clearPoses();
        }
        if (this.getCrawlManager() != null) {
            this.getCrawlManager().clearCrawls();
        }
        this.getEmoteManager().clearEmotes();
        this.getToggleManager().saveToggleData();
        if (this.getPlaceholderAPILink() != null) {
            this.getPlaceholderAPILink().unregister();
        }
        this.getMManager().sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-disabled", new Object[0]);
    }

    private void setupCommands() {
        this.getCommand("gsit").setExecutor((CommandExecutor)new GSitCommand(GSitMain.getInstance()));
        this.getCommand("gsit").setTabCompleter((TabCompleter)new GSitTabComplete(GSitMain.getInstance()));
        this.getCommand("glay").setExecutor((CommandExecutor)new GLayCommand(GSitMain.getInstance()));
        this.getCommand("glay").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("gbellyflop").setExecutor((CommandExecutor)new GBellyFlopCommand(GSitMain.getInstance()));
        this.getCommand("gbellyflop").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("gspin").setExecutor((CommandExecutor)new GSpinCommand(GSitMain.getInstance()));
        this.getCommand("gspin").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("gcrawl").setExecutor((CommandExecutor)new GCrawlCommand(GSitMain.getInstance()));
        this.getCommand("gcrawl").setTabCompleter((TabCompleter)new GCrawlTabComplete(GSitMain.getInstance()));
        this.getCommand("gemote").setExecutor((CommandExecutor)new GEmoteCommand(GSitMain.getInstance()));
        this.getCommand("gemote").setTabCompleter((TabCompleter)new GEmoteTabComplete(GSitMain.getInstance()));
        this.getCommand("gsitreload").setExecutor((CommandExecutor)new GSitReloadCommand(GSitMain.getInstance()));
        this.getCommand("gsitreload").setTabCompleter((TabCompleter)new EmptyTabComplete());
    }

    private void setupEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEvents(GSitMain.getInstance()), (Plugin)GSitMain.getInstance());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerSitEvents(GSitMain.getInstance()), (Plugin)GSitMain.getInstance());
        this.getServer().getPluginManager().registerEvents((Listener)new BlockEvents(GSitMain.getInstance()), (Plugin)GSitMain.getInstance());
        this.getServer().getPluginManager().registerEvents((Listener)new InteractEvents(GSitMain.getInstance()), (Plugin)GSitMain.getInstance());
    }

    private void loadPluginDepends(CommandSender s) {
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && Bukkit.getPluginManager().isPluginEnabled("WorldGuard")) {
            if (this.worldGuardLink == null) {
                this.worldGuardLink = new WorldGuardLink(GSitMain.getInstance());
                this.getWorldGuardLink().registerFlags();
            }
            this.getMManager().sendMessage(s, "Plugin.plugin-link", "%Link%", "WorldGuard");
        } else {
            this.worldGuardLink = null;
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null && Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.placeholderAPILink = new PlaceholderAPILink(GSitMain.getInstance());
            this.getMManager().sendMessage(s, "Plugin.plugin-link", "%Link%", "PlaceholderAPI");
            this.getPlaceholderAPILink().register();
        } else {
            this.placeholderAPILink = null;
        }
        if (Bukkit.getPluginManager().getPlugin("GriefPrevention") != null && Bukkit.getPluginManager().isPluginEnabled("GriefPrevention")) {
            this.griefPreventionLink = new GriefPreventionLink(GSitMain.getInstance());
            this.getMManager().sendMessage(s, "Plugin.plugin-link", "%Link%", "GriefPrevention");
        } else {
            this.griefPreventionLink = null;
        }
        if (Bukkit.getPluginManager().getPlugin("PlotSquared") != null && Bukkit.getPluginManager().isPluginEnabled("PlotSquared")) {
            this.plotSquaredLink = new PlotSquaredLink(GSitMain.getInstance());
            if (this.getPlotSquaredLink().isVersionSupported()) {
                this.getMManager().sendMessage(s, "Plugin.plugin-link", "%Link%", "PlotSquared");
            } else {
                this.plotSquaredLink = null;
            }
        } else {
            this.plotSquaredLink = null;
        }
    }

    private void copyLangFiles() {
        for (String lang : this.LANGS) {
            if (new File("plugins/GSit/lang/" + lang + ".yml").exists()) continue;
            this.saveResource("lang/" + lang + ".yml", false);
        }
    }

    private void copyEmoteFiles() {
        for (String l : this.EMOTES) {
            if (new File("plugins/GSit/emotes/" + l + ".gex").exists()) continue;
            this.saveResource("emotes/" + l + ".gex", false);
        }
    }

    public void reload(CommandSender Sender) {
        this.reloadConfig();
        this.getCManager().reload();
        this.getSitManager().clearSeats();
        if (this.getPoseManager() != null) {
            this.getPoseManager().clearPoses();
        }
        if (this.getCrawlManager() != null) {
            this.getCrawlManager().clearCrawls();
        }
        this.getEmoteManager().reloadEmotes();
        this.getToggleManager().saveToggleData();
        if (this.getPlaceholderAPILink() != null) {
            this.getPlaceholderAPILink().unregister();
        }
        this.loadSettings();
        this.loadPluginDepends(Sender);
        this.checkForUpdates();
    }

    private void checkForUpdates() {
        if (this.getCManager().CHECK_FOR_UPDATES) {
            this.getUManager().checkVersion();
            if (!this.getUManager().isLatestVersion()) {
                String message = this.getMManager().getMessage("Plugin.plugin-update", "%Name%", "GSit", "%NewVersion%", this.getUManager().getLatestVersion(), "%Version%", this.getUManager().getPluginVersion(), "%Path%", this.getDescription().getWebsite());
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!this.getPManager().hasPermission((CommandSender)player, "Update")) continue;
                    player.sendMessage(message);
                }
                Bukkit.getConsoleSender().sendMessage(message);
            }
        }
    }

    private boolean versionCheck() {
        if (this.SERVER < 1 || !NMSManager.isNewerOrVersion(13L, 0) || NMSManager.isNewerOrVersion(17L, 0) && NMSManager.getPackageObject("gsit", "manager.PoseManager", (Object)GSitMain.getInstance()) == null) {
            String version = Bukkit.getServer().getClass().getPackage().getName();
            this.getMManager().sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-version", "%Version%", this.SERVER < 1 ? "Bukkit" : version.substring(version.lastIndexOf(46) + 1));
            this.checkForUpdates();
            Bukkit.getPluginManager().disablePlugin((Plugin)GSitMain.getInstance());
            return false;
        }
        return true;
    }
}

