/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.util;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.GSeat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SitUtil {
    private final GSitMain GPM;

    public SitUtil(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    public boolean isSeatBlock(Block B) {
        return B.hasMetadata(this.GPM.NAME);
    }

    public List<GSeat> getSeats(Block B) {
        MetadataValue m;
        ArrayList<GSeat> seats = new ArrayList<GSeat>();
        if (this.isSeatBlock(B) && (m = (MetadataValue)B.getMetadata(this.GPM.NAME).stream().filter(s -> this.GPM.equals(s.getOwningPlugin())).findFirst().orElse(null)) != null) {
            seats = new ArrayList((List)m.value());
        }
        return seats;
    }

    public List<GSeat> getSeats(List<Block> B) {
        ArrayList<GSeat> seats = new ArrayList<GSeat>();
        for (Block b : B) {
            for (GSeat c : this.getSeats(b)) {
                if (seats.contains(c)) continue;
                seats.add(c);
            }
        }
        return seats;
    }

    public void setSeatBlock(Block B, GSeat S) {
        List<GSeat> seats = this.getSeats(B);
        if (!seats.contains(S)) {
            seats.add(S);
        }
        B.setMetadata(this.GPM.NAME, (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, seats));
    }

    public void removeSeatBlock(Block B, GSeat S) {
        List<GSeat> seats = this.getSeats(B);
        seats.remove(S);
        if (seats.size() > 0) {
            B.setMetadata(this.GPM.NAME, (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, seats));
        } else {
            B.removeMetadata(this.GPM.NAME, (Plugin)this.GPM);
        }
    }

    public GSeat createSeatForStair(Block Block2, Player Player2) {
        GSeat seat = null;
        Stairs bd = (Stairs)Block2.getBlockData();
        if (bd.getHalf() != Bisected.Half.BOTTOM) {
            return this.GPM.getSitManager().createSeat(Block2, Player2);
        }
        BlockFace f = bd.getFacing().getOppositeFace();
        Stairs.Shape s = bd.getShape();
        if (bd.getShape() == Stairs.Shape.STRAIGHT) {
            switch (f) {
                case EAST: {
                    seat = this.GPM.getSitManager().createSeat(Block2, Player2, false, 0.123, -0.5, 0.0, -90.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
                    break;
                }
                case SOUTH: {
                    seat = this.GPM.getSitManager().createSeat(Block2, Player2, false, 0.0, -0.5, 0.123, 0.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
                    break;
                }
                case WEST: {
                    seat = this.GPM.getSitManager().createSeat(Block2, Player2, false, -0.123, -0.5, 0.0, 90.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
                    break;
                }
                case NORTH: {
                    seat = this.GPM.getSitManager().createSeat(Block2, Player2, false, 0.0, -0.5, -0.123, 180.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
                    break;
                }
            }
        } else if (f == BlockFace.NORTH && s == Stairs.Shape.OUTER_RIGHT || f == BlockFace.EAST && s == Stairs.Shape.OUTER_LEFT || f == BlockFace.NORTH && s == Stairs.Shape.INNER_RIGHT || f == BlockFace.EAST && s == Stairs.Shape.INNER_LEFT) {
            seat = this.GPM.getSitManager().createSeat(Block2, Player2, false, 0.123, -0.5, -0.123, -135.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
        } else if (f == BlockFace.NORTH && s == Stairs.Shape.OUTER_LEFT || f == BlockFace.WEST && s == Stairs.Shape.OUTER_RIGHT || f == BlockFace.NORTH && s == Stairs.Shape.INNER_LEFT || f == BlockFace.WEST && s == Stairs.Shape.INNER_RIGHT) {
            seat = this.GPM.getSitManager().createSeat(Block2, Player2, false, -0.123, -0.5, -0.123, 135.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
        } else if (f == BlockFace.SOUTH && s == Stairs.Shape.OUTER_RIGHT || f == BlockFace.WEST && s == Stairs.Shape.OUTER_LEFT || f == BlockFace.SOUTH && s == Stairs.Shape.INNER_RIGHT || f == BlockFace.WEST && s == Stairs.Shape.INNER_LEFT) {
            seat = this.GPM.getSitManager().createSeat(Block2, Player2, false, -0.123, -0.5, 0.123, 45.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
        } else if (f == BlockFace.SOUTH && s == Stairs.Shape.OUTER_LEFT || f == BlockFace.EAST && s == Stairs.Shape.OUTER_RIGHT || f == BlockFace.SOUTH && s == Stairs.Shape.INNER_LEFT || f == BlockFace.EAST && s == Stairs.Shape.INNER_RIGHT) {
            seat = this.GPM.getSitManager().createSeat(Block2, Player2, false, 0.123, -0.5, 0.123, -45.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
        }
        return seat;
    }
}

