/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.util;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.IGPoseSeat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PoseUtil {
    private final GSitMain GPM;

    public PoseUtil(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    public boolean isPoseBlock(Block B) {
        return B.hasMetadata(this.GPM.NAME + "P");
    }

    public List<IGPoseSeat> getPoses(Block B) {
        MetadataValue m;
        ArrayList<IGPoseSeat> poses = new ArrayList<IGPoseSeat>();
        if (this.isPoseBlock(B) && (m = (MetadataValue)B.getMetadata(this.GPM.NAME + "P").stream().filter(s -> this.GPM.equals(s.getOwningPlugin())).findFirst().orElse(null)) != null) {
            poses = new ArrayList((List)m.value());
        }
        return poses;
    }

    public List<IGPoseSeat> getPoses(List<Block> B) {
        ArrayList<IGPoseSeat> poses = new ArrayList<IGPoseSeat>();
        for (Block b : B) {
            for (IGPoseSeat c : this.getPoses(b)) {
                if (poses.contains(c)) continue;
                poses.add(c);
            }
        }
        return poses;
    }

    public void setPoseBlock(Block B, IGPoseSeat P) {
        List<IGPoseSeat> poses = this.getPoses(B);
        if (!poses.contains(P)) {
            poses.add(P);
        }
        B.setMetadata(this.GPM.NAME + "P", (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, poses));
    }

    public void removePoseBlock(Block B, IGPoseSeat P) {
        List<IGPoseSeat> poses = this.getPoses(B);
        poses.remove(P);
        if (poses.size() > 0) {
            B.setMetadata(this.GPM.NAME + "P", (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, poses));
        } else {
            B.removeMetadata(this.GPM.NAME + "P", (Plugin)this.GPM);
        }
    }
}

