/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_18_R2.objects;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.GetUpReason;
import dev.geco.gsit.objects.IGCrawl;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GCrawl
implements IGCrawl {
    private final GSitMain GPM = GSitMain.getInstance();
    private final Player p;
    private final EntityPlayer cp;
    protected final EntityShulker s;
    private Location bloc;
    private boolean build;
    private boolean svalid;
    protected final BlockData m = Material.BARRIER.createBlockData();
    private final Listener li;
    private final Listener lim;
    private final Listener lic;

    public GCrawl(Player Player2) {
        this.p = Player2;
        this.cp = ((CraftPlayer)this.p).getHandle();
        this.s = this.createShulker();
        this.li = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void ETogSE(EntityToggleSwimEvent e) {
                if (e.getEntity() == GCrawl.this.p) {
                    e.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void PIntE(PlayerInteractEvent e) {
                if (e.getPlayer() == GCrawl.this.p && GCrawl.this.build && e.getClickedBlock().equals(GCrawl.this.bloc.getBlock()) && e.getHand() == EquipmentSlot.HAND) {
                    e.setCancelled(true);
                    new BukkitRunnable(){

                        public void run() {
                            GCrawl.this.buildBlock();
                        }
                    }.runTaskAsynchronously((Plugin)GCrawl.this.GPM);
                }
            }
        };
        this.lim = new Listener(){

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void PMovE(PlayerMoveEvent e) {
                if (e.getPlayer() == GCrawl.this.p) {
                    Location lf = e.getFrom();
                    Location lt = e.getTo();
                    if (lf.getX() != lt.getX() || lf.getZ() != lt.getZ() || lf.getY() != lt.getY()) {
                        GCrawl.this.tick(lf);
                    }
                }
            }
        };
        this.lic = new Listener(){

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void PTogSE(PlayerToggleSneakEvent e) {
                if (e.getPlayer() == GCrawl.this.p && e.isSneaking()) {
                    GCrawl.this.GPM.getCrawlManager().stopCrawl(GCrawl.this, GetUpReason.GET_UP);
                }
            }
        };
    }

    @Override
    public void start() {
        this.p.setSwimming(true);
        Bukkit.getPluginManager().registerEvents(this.li, (Plugin)this.GPM);
        new BukkitRunnable(){

            public void run() {
                Bukkit.getPluginManager().registerEvents(GCrawl.this.lim, (Plugin)GCrawl.this.GPM);
                if (GCrawl.this.GPM.getCManager().C_GET_UP_SNEAK) {
                    Bukkit.getPluginManager().registerEvents(GCrawl.this.lic, (Plugin)GCrawl.this.GPM);
                }
                GCrawl.this.tick(GCrawl.this.p.getLocation());
            }
        }.runTaskLaterAsynchronously((Plugin)this.GPM, 1L);
    }

    private void tick(final Location L) {
        boolean canreplace;
        if (!this.checkCrawlValid()) {
            return;
        }
        Location l = L.clone();
        final Block cblock = l.getBlock();
        final int bheight = (int)((l.getY() - (double)l.getBlockY()) * 100.0);
        l.setY((double)l.getBlockY() + (bheight >= 40 ? 2.49 : 1.49));
        Block topblock = l.getBlock();
        boolean solidblock = topblock.getBoundingBox().contains(l.toVector()) && topblock.getCollisionShape().getBoundingBoxes().size() > 0;
        boolean valid = this.isValidArea(cblock.getRelative(BlockFace.UP), topblock, this.bloc != null ? this.bloc.getBlock() : null);
        boolean bl = canreplace = valid && (topblock.getType().isAir() || solidblock);
        if (this.bloc == null || !topblock.equals(this.bloc.getBlock())) {
            this.destoryBlock();
            this.bloc = l;
            if (canreplace && !solidblock) {
                this.buildBlock();
            }
        }
        if (!canreplace && !solidblock) {
            new BukkitRunnable(){

                public void run() {
                    Location les = L.clone();
                    int h = cblock.getBoundingBox().getHeight() >= 0.4 || les.getY() % 0.015625 == 0.0 ? ((double)GCrawl.this.p.getFallDistance() > 0.7 ? 0 : bheight) : 0;
                    les.setY(les.getY() + (h >= 40 ? 1.5 : 0.5));
                    GCrawl.this.s.a(h >= 40 ? 100 - h : 0);
                    if (GCrawl.this.svalid) {
                        PacketPlayOutEntityMetadata pa = new PacketPlayOutEntityMetadata(GCrawl.this.s.ae(), GCrawl.this.s.ai(), true);
                        GCrawl.this.cp.b.a((Packet)pa);
                        GCrawl.this.s.m(les.getX(), les.getY(), les.getZ());
                        PacketPlayOutEntityTeleport pa2 = new PacketPlayOutEntityTeleport((Entity)GCrawl.this.s);
                        GCrawl.this.cp.b.a((Packet)pa2);
                    } else {
                        GCrawl.this.s.e(les.getX(), les.getY(), les.getZ());
                        PacketPlayOutSpawnEntity pa = new PacketPlayOutSpawnEntity((Entity)GCrawl.this.s);
                        GCrawl.this.cp.b.a((Packet)pa);
                        GCrawl.this.svalid = true;
                        PacketPlayOutEntityMetadata pa2 = new PacketPlayOutEntityMetadata(GCrawl.this.s.ae(), GCrawl.this.s.ai(), true);
                        GCrawl.this.cp.b.a((Packet)pa2);
                    }
                }
            }.runTask((Plugin)this.GPM);
        } else {
            this.destoryEntity();
        }
    }

    @Override
    public void stop() {
        HandlerList.unregisterAll((Listener)this.li);
        HandlerList.unregisterAll((Listener)this.lim);
        HandlerList.unregisterAll((Listener)this.lic);
        this.p.setSwimming(false);
        if (this.bloc != null) {
            this.p.sendBlockChange(this.bloc, this.bloc.getBlock().getBlockData());
        }
        this.cp.b.a((Packet)new PacketPlayOutEntityDestroy(new int[]{this.s.ae()}));
    }

    private void buildBlock() {
        this.p.sendBlockChange(this.bloc, this.m);
        this.build = true;
    }

    private void destoryBlock() {
        if (this.build) {
            this.p.sendBlockChange(this.bloc, this.bloc.getBlock().getBlockData());
            this.build = false;
        }
    }

    private void destoryEntity() {
        if (this.svalid) {
            this.cp.b.a((Packet)new PacketPlayOutEntityDestroy(new int[]{this.s.ae()}));
            this.svalid = false;
        }
    }

    private boolean checkCrawlValid() {
        if (this.cp.aQ() || this.p.isFlying()) {
            new BukkitRunnable(){

                public void run() {
                    GCrawl.this.GPM.getCrawlManager().stopCrawl(GCrawl.this, GetUpReason.ACTION);
                }
            }.runTask((Plugin)this.GPM);
            return false;
        }
        return true;
    }

    private boolean isValidArea(Block B, Block L, Block A) {
        return B.equals(L) || B.equals(A);
    }

    private EntityShulker createShulker() {
        EntityShulker s = new EntityShulker(EntityTypes.ay, (World)((CraftWorld)this.p.getWorld()).getHandle());
        s.j(true);
        s.m(true);
        s.s(true);
        s.d(true);
        s.a(EnumDirection.b);
        s.persist = false;
        return s;
    }

    @Override
    public Player getPlayer() {
        return this.p;
    }

    public String toString() {
        return this.s.cm().toString();
    }
}

