/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_18_R1.objects;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.GSeat;
import dev.geco.gsit.objects.IGPoseSeat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GPoseSeat
implements IGPoseSeat {
    private final GSitMain GPM = GSitMain.getInstance();
    private final GSeat s;
    private final Pose p;
    private Set<Player> a = new HashSet<Player>();
    private final EntityPlayer cp;
    protected final EntityPlayer f;
    private final Location bl;
    private final BlockData bd;
    private final BlockPosition bp;
    private final EnumDirection d;
    protected PacketPlayOutBlockChange set_bed;
    protected PacketPlayOutPlayerInfo add_npc;
    protected PacketPlayOutPlayerInfo remove_npc;
    protected PacketPlayOutEntityDestroy remove_entity;
    protected PacketPlayOutNamedEntitySpawn create_npc;
    protected PacketPlayOutEntityMetadata meta_npc;
    protected PacketPlayOutEntityTeleport set_npc;
    protected PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook rot_npc;
    private BukkitRunnable r;
    private final Listener li;

    public GPoseSeat(GSeat Seat, Pose Pose2) {
        this.s = Seat;
        this.p = Pose2;
        Location l = this.s.getLocation();
        this.cp = ((CraftPlayer)this.s.getPlayer()).getHandle();
        this.f = this.createNPC();
        this.f.b(l.getX(), l.getY() + (this.p == Pose.SLEEPING ? 0.3125 : (this.p == Pose.SPIN_ATTACK ? 0.2 : 0.0)), l.getZ(), 0.0f, 0.0f);
        this.bl = l.clone();
        this.bl.setY((double)this.bl.getWorld().getMinHeight());
        this.bd = this.bl.getBlock().getBlockData();
        this.bp = new BlockPosition(this.bl.getBlockX(), this.bl.getBlockY(), this.bl.getBlockZ());
        this.d = this.getDirection();
        IBlockData bs = Blocks.aD.n();
        bs = (IBlockData)bs.a((IBlockState)BlockBed.aE, (Comparable)this.d.f());
        bs = (IBlockData)bs.a((IBlockState)BlockBed.a, (Comparable)BlockPropertyBedPart.a);
        this.setMeta();
        if (this.p == Pose.SLEEPING) {
            this.set_bed = new PacketPlayOutBlockChange(this.bp, bs);
        }
        this.add_npc = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, new EntityPlayer[]{this.f});
        this.remove_npc = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, new EntityPlayer[]{this.f});
        this.remove_entity = new PacketPlayOutEntityDestroy(new int[]{this.f.ae()});
        this.create_npc = new PacketPlayOutNamedEntitySpawn((EntityHuman)this.f);
        this.meta_npc = new PacketPlayOutEntityMetadata(this.f.ae(), this.f.ai(), false);
        if (this.p == Pose.SLEEPING) {
            this.set_npc = new PacketPlayOutEntityTeleport((Entity)this.f);
        }
        if (this.p == Pose.SPIN_ATTACK) {
            this.rot_npc = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.f.ae(), 0, 0, 0, 0, this.getFixedRotation(-90.0f), true);
        }
        this.li = new Listener(){

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void PIntE(PlayerInteractEvent e) {
                if (e.getPlayer() == GPoseSeat.this.s.getPlayer() && !GPoseSeat.this.GPM.getCManager().P_INTERACT) {
                    e.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void PIntE(PlayerInteractEntityEvent e) {
                if (e.getPlayer() == GPoseSeat.this.s.getPlayer()) {
                    e.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void EDamBEE(EntityDamageByEntityEvent e) {
                if (e.getDamager() == GPoseSeat.this.s.getPlayer() && !GPoseSeat.this.GPM.getCManager().P_INTERACT) {
                    e.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void EDamE(EntityDamageEvent e) {
                if (e.getEntity() == GPoseSeat.this.s.getPlayer()) {
                    GPoseSeat.this.playAnimation(1);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void PLauE(ProjectileLaunchEvent e) {
                if (e.getEntity().getShooter() == GPoseSeat.this.s.getPlayer() && !GPoseSeat.this.GPM.getCManager().P_INTERACT) {
                    e.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void PAniE(PlayerAnimationEvent e) {
                if (e.getPlayer() == GPoseSeat.this.s.getPlayer() && e.getAnimationType() == PlayerAnimationType.ARM_SWING) {
                    GPoseSeat.this.playAnimation(e.getPlayer().getMainHand().equals((Object)MainHand.RIGHT) ? 0 : 3);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void PGamMCE(PlayerGameModeChangeEvent e) {
                if (e.getPlayer() == GPoseSeat.this.s.getPlayer() && e.getNewGameMode() == GameMode.CREATIVE) {
                    GPoseSeat.this.setEquipmentVisibility(true);
                }
            }
        };
    }

    @Override
    public void spawn() {
        this.a = this.getNearPlayers();
        this.cp.j(true);
        this.setEquipmentVisibility(false);
        this.f.ai().b(DataWatcherRegistry.p.a(19), (Object)((NBTTagCompound)this.cp.ai().a(DataWatcherRegistry.p.a(19))));
        this.f.ai().b(DataWatcherRegistry.p.a(20), (Object)((NBTTagCompound)this.cp.ai().a(DataWatcherRegistry.p.a(20))));
        this.cp.ai().b(DataWatcherRegistry.p.a(19), (Object)new NBTTagCompound());
        this.cp.ai().b(DataWatcherRegistry.p.a(20), (Object)new NBTTagCompound());
        if (this.p == Pose.SLEEPING) {
            if (this.GPM.getCManager().P_LAY_NIGHT_SKIP) {
                this.s.getPlayer().setSleepingIgnored(true);
            }
            if (this.GPM.getCManager().P_LAY_REST) {
                this.s.getPlayer().setStatistic(Statistic.TIME_SINCE_REST, 0);
            }
        }
        for (Player z : this.a) {
            this.spawnToPlayer(z);
        }
        Bukkit.getPluginManager().registerEvents(this.li, (Plugin)this.GPM);
        this.startUpdate();
    }

    private void spawnToPlayer(Player z) {
        final EntityPlayer sp = ((CraftPlayer)z).getHandle();
        sp.b.a((Packet)this.add_npc);
        sp.b.a((Packet)this.create_npc);
        if (this.p == Pose.SLEEPING) {
            sp.b.a((Packet)this.set_bed);
        }
        sp.b.a((Packet)this.meta_npc);
        if (this.p == Pose.SLEEPING) {
            sp.b.a((Packet)this.set_npc);
        }
        if (this.p == Pose.SPIN_ATTACK) {
            sp.b.a((Packet)this.rot_npc);
        }
        new BukkitRunnable(){

            public void run() {
                sp.b.a((Packet)GPoseSeat.this.remove_npc);
            }
        }.runTaskLater((Plugin)this.GPM, 15L);
    }

    @Override
    public void remove() {
        this.stopUpdate();
        HandlerList.unregisterAll((Listener)this.li);
        for (Player z : this.a) {
            this.removeToPlayer(z);
        }
        if (this.p == Pose.SLEEPING && this.GPM.getCManager().P_LAY_NIGHT_SKIP) {
            this.s.getPlayer().setSleepingIgnored(false);
        }
        this.cp.j(false);
        this.setEquipmentVisibility(true);
        this.s.getPlayer().setInvisible(false);
        this.cp.ai().b(DataWatcherRegistry.p.a(19), (Object)((NBTTagCompound)this.f.ai().a(DataWatcherRegistry.p.a(19))));
        this.cp.ai().b(DataWatcherRegistry.p.a(20), (Object)((NBTTagCompound)this.f.ai().a(DataWatcherRegistry.p.a(20))));
    }

    private void removeToPlayer(Player z) {
        EntityPlayer sp = ((CraftPlayer)z).getHandle();
        sp.b.a((Packet)this.remove_npc);
        sp.b.a((Packet)this.remove_entity);
        z.sendBlockChange(this.bl, this.bd);
    }

    private Set<Player> getNearPlayers() {
        HashSet<Player> pl = new HashSet<Player>();
        this.s.getLocation().getWorld().getPlayers().stream().filter(o -> this.s.getLocation().distance(o.getLocation()) <= 250.0 && o.canSee(this.s.getPlayer())).forEach(pl::add);
        return pl;
    }

    private void startUpdate() {
        this.r = new BukkitRunnable(){
            long sleep_tick = 0L;

            public void run() {
                Set<Player> np = GPoseSeat.this.getNearPlayers();
                for (Player z : np) {
                    if (GPoseSeat.this.a.contains(z)) continue;
                    GPoseSeat.this.a.add(z);
                    GPoseSeat.this.spawnToPlayer(z);
                }
                for (Player z : new HashSet<Player>(GPoseSeat.this.a)) {
                    if (np.contains(z)) continue;
                    GPoseSeat.this.a.remove(z);
                    GPoseSeat.this.removeToPlayer(z);
                }
                if (GPoseSeat.this.p != Pose.SPIN_ATTACK) {
                    GPoseSeat.this.updateDirection();
                }
                GPoseSeat.this.cp.j(true);
                GPoseSeat.this.updateEquipment();
                GPoseSeat.this.setEquipmentVisibility(false);
                GPoseSeat.this.updateSkin();
                if (GPoseSeat.this.p == Pose.SLEEPING) {
                    for (Player z : GPoseSeat.this.a) {
                        EntityPlayer sp = ((CraftPlayer)z).getHandle();
                        sp.b.a((Packet)GPoseSeat.this.set_bed);
                    }
                    if (GPoseSeat.this.GPM.getCManager().P_LAY_SNORING_SOUNDS) {
                        ++this.sleep_tick;
                        if (this.sleep_tick >= 90L) {
                            long ti = GPoseSeat.this.s.getPlayer().getPlayerTime();
                            if (!GPoseSeat.this.GPM.getCManager().P_LAY_SNORING_NIGHT_ONLY || ti >= 12500L && ti <= 23500L) {
                                for (Player z : GPoseSeat.this.a) {
                                    z.playSound(GPoseSeat.this.s.getLocation(), Sound.ENTITY_FOX_SLEEP, SoundCategory.PLAYERS, 1.5f, 0.0f);
                                }
                            }
                            this.sleep_tick = 0L;
                        }
                    }
                }
            }
        };
        this.r.runTaskTimerAsynchronously((Plugin)this.GPM, 5L, 1L);
    }

    private void stopUpdate() {
        if (this.r != null && !this.r.isCancelled()) {
            this.r.cancel();
        }
    }

    private void setMeta() {
        this.f.ai().b(DataWatcherRegistry.s.a(6), (Object)EntityPose.values()[this.p.ordinal()]);
        this.f.ai().b(DataWatcherRegistry.a.a(17), (Object)((Byte)this.cp.ai().a(DataWatcherRegistry.a.a(17))));
        this.f.ai().b(DataWatcherRegistry.a.a(18), (Object)((Byte)this.cp.ai().a(DataWatcherRegistry.a.a(18))));
        if (this.p == Pose.SPIN_ATTACK) {
            this.f.ai().b(DataWatcherRegistry.a.a(8), (Object)4);
        }
        if (this.p == Pose.SLEEPING) {
            this.f.ai().b(DataWatcherRegistry.m.a(14), Optional.of(this.bp));
        }
    }

    private float fixYaw(float Y) {
        return (Y < 0.0f ? 360.0f + Y : Y) % 360.0f;
    }

    private void updateDirection() {
        if (this.p == Pose.SWIMMING) {
            byte y = this.getFixedRotation(this.s.getPlayer().getLocation().getYaw());
            PacketPlayOutEntityHeadRotation pa = new PacketPlayOutEntityHeadRotation((Entity)this.f, y);
            PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook pa2 = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.f.ae(), 0, 0, 0, y, 0, true);
            for (Player z : this.a) {
                EntityPlayer sp = ((CraftPlayer)z).getHandle();
                sp.b.a((Packet)pa);
                sp.b.a((Packet)pa2);
            }
            return;
        }
        float yc = this.s.getPlayer().getLocation().getYaw();
        if (this.d == EnumDirection.e) {
            yc -= 90.0f;
        }
        if (this.d == EnumDirection.f) {
            yc += 90.0f;
        }
        if (this.d == EnumDirection.c) {
            yc -= 180.0f;
        }
        byte y = this.getFixedRotation((yc = this.fixYaw(yc)) >= 315.0f ? yc - 360.0f : (yc <= 45.0f ? yc : (yc >= 180.0f ? -45.0f : 45.0f)));
        PacketPlayOutEntityHeadRotation pa = new PacketPlayOutEntityHeadRotation((Entity)this.f, y);
        for (Player z : this.a) {
            EntityPlayer sp = ((CraftPlayer)z).getHandle();
            sp.b.a((Packet)pa);
        }
    }

    private void updateSkin() {
        DataWatcher sed = this.f.ai();
        sed.b(DataWatcherRegistry.a.a(17), (Object)((Byte)this.cp.ai().a(DataWatcherRegistry.a.a(17))));
        sed.b(DataWatcherRegistry.a.a(18), (Object)((Byte)this.cp.ai().a(DataWatcherRegistry.a.a(18))));
        PacketPlayOutEntityMetadata pa = new PacketPlayOutEntityMetadata(this.f.ae(), sed, false);
        for (Player z : this.a) {
            EntityPlayer sp = ((CraftPlayer)z).getHandle();
            sp.b.a((Packet)pa);
        }
    }

    private void updateEquipment() {
        ArrayList<Pair> lp = new ArrayList<Pair>();
        for (EnumItemSlot es : EnumItemSlot.values()) {
            net.minecraft.world.item.ItemStack is = this.cp.b(es);
            if (is == null) continue;
            lp.add(Pair.of((Object)es, (Object)is));
        }
        PacketPlayOutEntityEquipment pa = new PacketPlayOutEntityEquipment(this.f.ae(), lp);
        for (Player z : this.a) {
            EntityPlayer sp = ((CraftPlayer)z).getHandle();
            sp.b.a((Packet)pa);
        }
    }

    private void setEquipmentVisibility(boolean v) {
        ArrayList<Pair> lp = new ArrayList<Pair>();
        net.minecraft.world.item.ItemStack nis = CraftItemStack.asNMSCopy((ItemStack)new ItemStack(Material.AIR));
        for (EnumItemSlot es : EnumItemSlot.values()) {
            net.minecraft.world.item.ItemStack is = v ? this.cp.b(es) : null;
            lp.add(Pair.of((Object)es, (Object)(is != null ? is : nis)));
        }
        PacketPlayOutEntityEquipment pa = new PacketPlayOutEntityEquipment(this.cp.ae(), lp);
        for (Player z : this.a) {
            if (z == this.s.getPlayer()) continue;
            EntityPlayer sp = ((CraftPlayer)z).getHandle();
            sp.b.a((Packet)pa);
        }
        if (this.s.getPlayer().getGameMode() != GameMode.CREATIVE) {
            this.s.getPlayer().updateInventory();
            if (!v) {
                this.cp.b.a((Packet)pa);
            }
        }
    }

    private void playAnimation(int A) {
        PacketPlayOutAnimation pa = new PacketPlayOutAnimation((Entity)this.f, A);
        for (Player z : this.a) {
            EntityPlayer sp = ((CraftPlayer)z).getHandle();
            sp.b.a((Packet)pa);
        }
    }

    private byte getFixedRotation(float Y) {
        return (byte)(Y * 256.0f / 360.0f);
    }

    private EnumDirection getDirection() {
        float y = this.s.getLocation().getYaw();
        if (y >= 135.0f || y < -135.0f) {
            return EnumDirection.c;
        }
        if (y >= -135.0f && y < -45.0f) {
            return EnumDirection.f;
        }
        if (y >= -45.0f && y < 45.0f) {
            return EnumDirection.d;
        }
        if (y >= 45.0f) {
            return EnumDirection.e;
        }
        return EnumDirection.c;
    }

    private EntityPlayer createNPC() {
        DedicatedServer mcs = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer sl = ((CraftWorld)this.s.getLocation().getWorld()).getHandle();
        GameProfile pf = new GameProfile(UUID.randomUUID(), this.GPM.getMManager().toColoredString(this.s.getPlayer().getName()));
        pf.getProperties().putAll((Multimap)this.cp.fp().getProperties());
        return new EntityPlayer((MinecraftServer)mcs, sl, pf);
    }

    @Override
    public GSeat getSeat() {
        return this.s;
    }

    @Override
    public Pose getPose() {
        return this.p;
    }

    public String toString() {
        return this.s.toString();
    }
}

