/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_17_R1_2.manager;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.api.event.PlayerGetUpPoseEvent;
import dev.geco.gsit.api.event.PlayerPoseEvent;
import dev.geco.gsit.api.event.PrePlayerGetUpPoseEvent;
import dev.geco.gsit.api.event.PrePlayerPoseEvent;
import dev.geco.gsit.manager.IPoseManager;
import dev.geco.gsit.mcv.v1_17_R1_2.objects.GPoseSeat;
import dev.geco.gsit.objects.GSeat;
import dev.geco.gsit.objects.GetUpReason;
import dev.geco.gsit.objects.IGPoseSeat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.ChatMessageType;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PoseManager
implements IPoseManager {
    private final GSitMain GPM;
    private int feature_used = 0;
    private final List<IGPoseSeat> poses = new ArrayList<IGPoseSeat>();
    private final HashMap<IGPoseSeat, BukkitRunnable> rotate = new HashMap();

    public PoseManager(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @Override
    public int getFeatureUsedCount() {
        return this.feature_used;
    }

    @Override
    public void resetFeatureUsedCount() {
        this.feature_used = 0;
    }

    @Override
    public List<IGPoseSeat> getPoses() {
        return new ArrayList<IGPoseSeat>(this.poses);
    }

    @Override
    public boolean isPosing(Player Player2) {
        return this.getPose(Player2) != null;
    }

    @Override
    public IGPoseSeat getPose(Player Player2) {
        for (IGPoseSeat p : this.getPoses()) {
            if (!Player2.equals(p.getSeat().getPlayer())) continue;
            return p;
        }
        return null;
    }

    @Override
    public void clearPoses() {
        for (IGPoseSeat p : this.getPoses()) {
            this.removePose(p, GetUpReason.PLUGIN);
        }
    }

    @Override
    public boolean kickPose(Block Block2, Player Player2) {
        if (this.GPM.getPoseUtil().isPoseBlock(Block2)) {
            if (!this.GPM.getPManager().hasPermission((CommandSender)Player2, "Kick.Pose", "Kick.*")) {
                return false;
            }
            for (IGPoseSeat p : this.GPM.getPoseUtil().getPoses(Block2)) {
                if (this.removePose(p, GetUpReason.KICKED)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public IGPoseSeat createPose(Block Block2, Player Player2, Pose Pose2) {
        return this.createPose(Block2, Player2, Pose2, 0.0, 0.0, 0.0, Player2.getLocation().getYaw(), this.GPM.getCManager().CENTER_BLOCK, this.GPM.getCManager().GET_UP_SNEAK);
    }

    @Override
    public IGPoseSeat createPose(Block Block2, Player Player2, Pose Pose2, double XOffset, double YOffset, double ZOffset, float SeatRotation, boolean SitAtBlock, boolean GetUpSneak) {
        double o;
        PrePlayerPoseEvent pplape = new PrePlayerPoseEvent(Player2, Block2);
        Bukkit.getPluginManager().callEvent((Event)pplape);
        if (pplape.isCancelled()) {
            return null;
        }
        double d = o = SitAtBlock ? Block2.getBoundingBox().getMinY() + Block2.getBoundingBox().getHeight() : 0.0;
        o = (SitAtBlock ? (o == 0.0 ? 1.0 : o - (double)Block2.getY()) : o) + this.GPM.getCManager().S_SITMATERIALS.getOrDefault(Block2.getType(), 0.0);
        Location l = Player2.getLocation().clone();
        Location r = l.clone();
        l = SitAtBlock ? Block2.getLocation().clone().add(0.5 + XOffset, YOffset + o - 0.2, 0.5 + ZOffset) : l.add(XOffset, YOffset - 0.2 + this.GPM.getCManager().S_SITMATERIALS.getOrDefault(Block2.getType(), 0.0), ZOffset);
        if (!this.GPM.getSpawnUtil().checkLocation(l)) {
            return null;
        }
        l.setYaw(SeatRotation);
        Entity sa = this.GPM.getSpawnUtil().createSeatEntity(l, (Entity)Player2);
        if (this.GPM.getCManager().P_POSE_MESSAGE) {
            Player2.spigot().sendMessage(ChatMessageType.ACTION_BAR, this.GPM.getMManager().getComplexMessage(this.GPM.getMManager().getRawMessage("Messages.action-pose-info", new Object[0]), new ItemStack[0]));
        }
        GSeat seat = new GSeat(Block2, l, Player2, sa, r);
        GPoseSeat poseseat = new GPoseSeat(seat, Pose2);
        poseseat.spawn();
        sa.setMetadata(this.GPM.NAME + "P", (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, (Object)poseseat));
        this.poses.add(poseseat);
        this.GPM.getPoseUtil().setPoseBlock(Block2, poseseat);
        this.startRotateSeat(poseseat);
        ++this.feature_used;
        Bukkit.getPluginManager().callEvent((Event)new PlayerPoseEvent(poseseat));
        return poseseat;
    }

    protected void startRotateSeat(final IGPoseSeat PoseSeat) {
        if (this.rotate.containsKey(PoseSeat)) {
            this.stopRotateSeat(PoseSeat);
        }
        BukkitRunnable r = new BukkitRunnable(){

            public void run() {
                if (!PoseManager.this.poses.contains(PoseSeat) || PoseSeat.getSeat().getEntity().getPassengers().isEmpty()) {
                    this.cancel();
                    return;
                }
                Location l = ((Entity)PoseSeat.getSeat().getEntity().getPassengers().get(0)).getLocation();
                PoseSeat.getSeat().getEntity().setRotation(l.getYaw(), l.getPitch());
            }
        };
        r.runTaskTimer((Plugin)this.GPM, 0L, 2L);
        this.rotate.put(PoseSeat, r);
    }

    protected void stopRotateSeat(IGPoseSeat PoseSeat) {
        if (!this.rotate.containsKey(PoseSeat)) {
            return;
        }
        BukkitRunnable r = this.rotate.get(PoseSeat);
        if (r != null && !r.isCancelled()) {
            r.cancel();
        }
        this.rotate.remove(PoseSeat);
    }

    @Override
    public boolean removePose(IGPoseSeat PoseSeat, GetUpReason Reason) {
        return this.removePose(PoseSeat, Reason, true);
    }

    @Override
    public boolean removePose(IGPoseSeat PoseSeat, GetUpReason Reason, boolean Safe) {
        Location l;
        PrePlayerGetUpPoseEvent pplagupe = new PrePlayerGetUpPoseEvent(PoseSeat, Reason);
        Bukkit.getPluginManager().callEvent((Event)pplagupe);
        if (pplagupe.isCancelled()) {
            return false;
        }
        this.GPM.getPoseUtil().removePoseBlock(PoseSeat.getSeat().getBlock(), PoseSeat);
        this.poses.remove(PoseSeat);
        this.stopRotateSeat(PoseSeat);
        PoseSeat.remove();
        Location location = this.GPM.getCManager().GET_UP_RETURN ? PoseSeat.getSeat().getReturn() : (l = PoseSeat.getSeat().getLocation().add(0.0, 0.2 + (Tag.STAIRS.isTagged((Keyed)PoseSeat.getSeat().getBlock().getType()) ? 0.5 : 0.0) - this.GPM.getCManager().S_SITMATERIALS.getOrDefault(PoseSeat.getSeat().getBlock().getType(), 0.0), 0.0));
        if (!this.GPM.getCManager().GET_UP_RETURN) {
            l.setYaw(PoseSeat.getSeat().getPlayer().getLocation().getYaw());
            l.setPitch(PoseSeat.getSeat().getPlayer().getLocation().getPitch());
        }
        if (PoseSeat.getSeat().getPlayer().isValid() && Safe) {
            this.GPM.getPlayerUtil().pos((Entity)PoseSeat.getSeat().getPlayer(), l);
            this.GPM.getPlayerUtil().teleport(PoseSeat.getSeat().getPlayer(), l, true);
        }
        if (PoseSeat.getSeat().getEntity().isValid()) {
            PoseSeat.getSeat().getEntity().remove();
        }
        Bukkit.getPluginManager().callEvent((Event)new PlayerGetUpPoseEvent(PoseSeat, Reason));
        return true;
    }
}

