/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.manager;

import dev.geco.gsit.GSitMain;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ToggleManager {
    private final GSitMain GPM;
    private File TData;
    private FileConfiguration TD;
    private final List<UUID> t = new ArrayList<UUID>();
    private final List<UUID> pt = new ArrayList<UUID>();
    private BukkitRunnable r;

    public ToggleManager(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    public boolean canSit(UUID U) {
        return this.GPM.getCManager().S_DEFAULT_SIT_MODE != this.t.contains(U);
    }

    public boolean canPlayerSit(UUID U) {
        return this.GPM.getCManager().PS_DEFAULT_SIT_MODE != this.pt.contains(U);
    }

    public void setCanSit(UUID U, boolean T) {
        if (T && this.GPM.getCManager().S_DEFAULT_SIT_MODE || !T && !this.GPM.getCManager().S_DEFAULT_SIT_MODE) {
            this.t.remove(U);
        } else {
            this.t.add(U);
        }
    }

    public void setCanPlayerSit(UUID U, boolean P) {
        if (P && this.GPM.getCManager().PS_DEFAULT_SIT_MODE || !P && !this.GPM.getCManager().PS_DEFAULT_SIT_MODE) {
            this.pt.remove(U);
        } else {
            this.pt.add(U);
        }
    }

    public void loadToggleData() {
        this.t.clear();
        this.pt.clear();
        this.TData = new File("plugins/" + this.GPM.NAME, "data/t.data");
        this.TD = YamlConfiguration.loadConfiguration((File)this.TData);
        for (String z : this.TD.getStringList("T")) {
            this.t.add(UUID.fromString(z));
        }
        for (String z : this.TD.getStringList("P")) {
            this.pt.add(UUID.fromString(z));
        }
        this.startAutoSave();
    }

    public void saveToggleData() {
        this.stopAutoSave();
        this.quickSaveToggleData();
    }

    private void quickSaveToggleData() {
        this.TD.set("T", null);
        this.TD.set("P", null);
        ArrayList<String> tc = new ArrayList<String>();
        for (UUID z : this.t) {
            tc.add(z.toString());
        }
        this.TD.set("T", tc);
        ArrayList<String> pc = new ArrayList<String>();
        for (UUID z : this.pt) {
            pc.add(z.toString());
        }
        this.TD.set("P", pc);
        this.saveFile(this.TData, this.TD);
    }

    private void startAutoSave() {
        this.stopAutoSave();
        this.r = new BukkitRunnable(){

            public void run() {
                ToggleManager.this.quickSaveToggleData();
            }
        };
        long t = 3600L;
        this.r.runTaskTimerAsynchronously((Plugin)this.GPM, t, t);
    }

    private void stopAutoSave() {
        if (this.r != null) {
            this.r.cancel();
        }
    }

    private void saveFile(File f, FileConfiguration fc) {
        try {
            fc.save(f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

