/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.manager;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.api.event.PlayerGetUpSitEvent;
import dev.geco.gsit.api.event.PlayerSitEvent;
import dev.geco.gsit.api.event.PrePlayerGetUpSitEvent;
import dev.geco.gsit.api.event.PrePlayerSitEvent;
import dev.geco.gsit.manager.ISitManager;
import dev.geco.gsit.manager.NMSManager;
import dev.geco.gsit.objects.GSeat;
import dev.geco.gsit.objects.GetUpReason;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.ChatMessageType;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SitManager
implements ISitManager {
    private final GSitMain GPM;
    private int feature_used = 0;
    private final List<GSeat> seats = new ArrayList<GSeat>();
    private final HashMap<GSeat, BukkitRunnable> rotate = new HashMap();

    public SitManager(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @Override
    public int getFeatureUsedCount() {
        return this.feature_used;
    }

    @Override
    public void resetFeatureUsedCount() {
        this.feature_used = 0;
    }

    @Override
    public List<GSeat> getSeats() {
        return new ArrayList<GSeat>(this.seats);
    }

    @Override
    public boolean isSitting(Player Player2) {
        return this.getSeat(Player2) != null;
    }

    @Override
    public GSeat getSeat(Player Player2) {
        for (GSeat s : this.getSeats()) {
            if (!Player2.equals(s.getPlayer())) continue;
            return s;
        }
        return null;
    }

    @Override
    public void clearSeats() {
        for (GSeat s : this.getSeats()) {
            this.removeSeat(s, GetUpReason.PLUGIN);
        }
    }

    @Override
    public boolean kickSeat(Block Block2, Player Player2) {
        if (this.GPM.getSitUtil().isSeatBlock(Block2)) {
            if (!this.GPM.getPManager().hasPermission((CommandSender)Player2, "Kick.Sit")) {
                return false;
            }
            for (GSeat s : this.GPM.getSitUtil().getSeats(Block2)) {
                if (this.removeSeat(s, GetUpReason.KICKED)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public GSeat createSeat(Block Block2, Player Player2) {
        return this.createSeat(Block2, Player2, true, 0.0, 0.0, 0.0, Player2.getLocation().getYaw(), this.GPM.getCManager().CENTER_BLOCK, true);
    }

    @Override
    public GSeat createSeat(Block Block2, Player Player2, boolean Rotate, double XOffset, double YOffset, double ZOffset, float SeatRotation, boolean SitAtBlock, boolean GetUpSneak) {
        double o;
        PrePlayerSitEvent pplase = new PrePlayerSitEvent(Player2, Block2);
        Bukkit.getPluginManager().callEvent((Event)pplase);
        if (pplase.isCancelled()) {
            return null;
        }
        double d = o = SitAtBlock ? Block2.getBoundingBox().getMinY() + Block2.getBoundingBox().getHeight() : 0.0;
        o = (SitAtBlock ? (o == 0.0 ? 1.0 : o - (double)Block2.getY()) : o) + this.GPM.getCManager().S_SITMATERIALS.getOrDefault(Block2.getType(), 0.0);
        Location l = Player2.getLocation().clone();
        Location r = l.clone();
        l = SitAtBlock ? Block2.getLocation().clone().add(0.5 + XOffset, YOffset + o - 0.2, 0.5 + ZOffset) : l.add(XOffset, YOffset - 0.2 + this.GPM.getCManager().S_SITMATERIALS.getOrDefault(Block2.getType(), 0.0), ZOffset);
        if (!this.GPM.getSpawnUtil().checkLocation(l)) {
            return null;
        }
        l.setYaw(SeatRotation);
        Entity sa = this.GPM.getSpawnUtil().createSeatEntity(l, (Entity)Player2);
        if (this.GPM.getCManager().S_SIT_MESSAGE) {
            Player2.spigot().sendMessage(ChatMessageType.ACTION_BAR, this.GPM.getMManager().getComplexMessage(this.GPM.getMManager().getRawMessage("Messages.action-sit-info", new Object[0]), new ItemStack[0]));
        }
        GSeat seat = new GSeat(Block2, l, Player2, sa, r);
        sa.setMetadata(this.GPM.NAME, (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, (Object)seat));
        this.seats.add(seat);
        this.GPM.getSitUtil().setSeatBlock(Block2, seat);
        if (Rotate) {
            this.startRotateSeat(seat);
        }
        ++this.feature_used;
        Bukkit.getPluginManager().callEvent((Event)new PlayerSitEvent(seat));
        return seat;
    }

    @Override
    public void moveSeat(final GSeat Seat, final BlockFace Face) {
        new BukkitRunnable(){

            public void run() {
                SitManager.this.GPM.getSitUtil().removeSeatBlock(Seat.getBlock(), Seat);
                Seat.setBlock(Seat.getBlock().getRelative(Face));
                Seat.setLocation(Seat.getLocation().add((double)Face.getModX(), (double)Face.getModY(), (double)Face.getModZ()));
                SitManager.this.GPM.getSitUtil().setSeatBlock(Seat.getBlock(), Seat);
                SitManager.this.GPM.getPlayerUtil().pos(Seat.getEntity(), Seat.getLocation());
            }
        }.runTaskLater((Plugin)this.GPM, 0L);
    }

    protected void startRotateSeat(final GSeat Seat) {
        if (this.rotate.containsKey(Seat)) {
            this.stopRotateSeat(Seat);
        }
        BukkitRunnable r = new BukkitRunnable(){

            public void run() {
                if (!SitManager.this.seats.contains(Seat) || Seat.getEntity().getPassengers().isEmpty()) {
                    this.cancel();
                    return;
                }
                Location l = ((Entity)Seat.getEntity().getPassengers().get(0)).getLocation();
                Seat.getEntity().setRotation(l.getYaw(), l.getPitch());
            }
        };
        r.runTaskTimer((Plugin)this.GPM, 0L, 2L);
        this.rotate.put(Seat, r);
    }

    protected void stopRotateSeat(GSeat Seat) {
        if (!this.rotate.containsKey(Seat)) {
            return;
        }
        BukkitRunnable r = this.rotate.get(Seat);
        if (r != null) {
            r.cancel();
        }
        this.rotate.remove(Seat);
    }

    @Override
    public boolean removeSeat(GSeat Seat, GetUpReason Reason) {
        return this.removeSeat(Seat, Reason, true);
    }

    @Override
    public boolean removeSeat(GSeat Seat, GetUpReason Reason, boolean Safe) {
        Location l;
        PrePlayerGetUpSitEvent pplaguse = new PrePlayerGetUpSitEvent(Seat, Reason);
        Bukkit.getPluginManager().callEvent((Event)pplaguse);
        if (pplaguse.isCancelled()) {
            return false;
        }
        this.GPM.getSitUtil().removeSeatBlock(Seat.getBlock(), Seat);
        this.seats.remove(Seat);
        this.stopRotateSeat(Seat);
        Location location = this.GPM.getCManager().GET_UP_RETURN ? Seat.getReturn() : (l = Seat.getLocation().add(0.0, 0.2 + (Tag.STAIRS.isTagged((Keyed)Seat.getBlock().getType()) ? 0.5 : 0.0) - this.GPM.getCManager().S_SITMATERIALS.getOrDefault(Seat.getBlock().getType(), 0.0), 0.0));
        if (!this.GPM.getCManager().GET_UP_RETURN) {
            l.setYaw(Seat.getPlayer().getLocation().getYaw());
            l.setPitch(Seat.getPlayer().getLocation().getPitch());
        }
        if (Seat.getPlayer().isValid() && Safe && NMSManager.isNewerOrVersion(17L, 0)) {
            this.GPM.getPlayerUtil().pos((Entity)Seat.getPlayer(), l);
            this.GPM.getPlayerUtil().teleport(Seat.getPlayer(), l, true);
        }
        if (Seat.getEntity().isValid()) {
            if (!NMSManager.isNewerOrVersion(17L, 0)) {
                this.GPM.getPlayerUtil().pos(Seat.getEntity(), l);
            }
            Seat.getEntity().remove();
        }
        Bukkit.getPluginManager().callEvent((Event)new PlayerGetUpSitEvent(Seat, Reason));
        return true;
    }
}

