/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.manager;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class NMSManager {
    private static final Map<Class<?>, Class<?>> CORRESPONDING_TYPES = new HashMap();

    private static Class<?> getPrimitiveType(Class<?> Class2) {
        return CORRESPONDING_TYPES.getOrDefault(Class2, Class2);
    }

    private static Class<?>[] toPrimitiveTypeArray(Class<?>[] Classes) {
        int L = Classes != null ? Classes.length : 0;
        Class[] T = new Class[L];
        for (int i = 0; i < L; ++i) {
            T[i] = NMSManager.getPrimitiveType(Classes[i]);
        }
        return T;
    }

    private static boolean equalsTypeArray(Class<?>[] Value1, Class<?>[] Value2) {
        if (Value1.length != Value2.length) {
            return false;
        }
        for (int i = 0; i < Value1.length; ++i) {
            if (Value1[i].equals(Value2[i]) || Value1[i].isAssignableFrom(Value2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean classListEqual(Class<?>[] Value1, Class<?>[] Value2) {
        if (Value1.length != Value2.length) {
            return false;
        }
        for (int i = 0; i < Value1.length; ++i) {
            if (Value1[i] == Value2[i]) continue;
            return false;
        }
        return true;
    }

    public static String getClassVersion() {
        String V = Bukkit.getServer().getClass().getPackage().getName();
        return V.substring(V.lastIndexOf(46) + 1);
    }

    public static String getPackageVersion() {
        return NMSManager.getClassVersion() + (NMSManager.isVersion(17L, 1) ? "_2" : "");
    }

    public static String getVersion() {
        return Bukkit.getBukkitVersion().substring(0, Bukkit.getBukkitVersion().indexOf(45));
    }

    public static boolean isNewerOrVersion(long Version2, int SubVersion) {
        String[] V = NMSManager.getVersion().split("\\.");
        return V.length > 1 && (V.length > 2 ? Long.parseLong(V[1]) >= Version2 && Long.parseLong(V[2]) >= (long)SubVersion : Long.parseLong(V[1]) >= Version2);
    }

    public static boolean isVersion(long Version2, int SubVersion) {
        String[] V = NMSManager.getVersion().split("\\.");
        return V.length > 1 && (V.length > 2 ? Long.parseLong(V[1]) == Version2 && Long.parseLong(V[2]) == (long)SubVersion : Long.parseLong(V[1]) == Version2);
    }

    public static Field getField(Class<?> Class2, String Field2) {
        try {
            Field F = Class2.getDeclaredField(Field2);
            F.setAccessible(true);
            return F;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPackageObject(String Name, String ClassName, Object O) {
        try {
            Class<?> sm = Class.forName("dev.geco." + Name + ".mcv." + NMSManager.getPackageVersion() + "." + ClassName);
            return O == null ? sm.getConstructor(new Class[0]).newInstance(new Object[0]) : sm.getConstructor(O.getClass()).newInstance(O);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> getNMSClass(String ClassName) {
        Class<?> C = null;
        try {
            return Class.forName("net.minecraft.server." + NMSManager.getClassVersion() + "." + ClassName);
        }
        catch (Exception exception) {
            return C;
        }
    }

    public static Class<?> getOBCClass(String ClassName) {
        Class<?> C = null;
        try {
            return Class.forName("org.bukkit.craftbukkit." + NMSManager.getClassVersion() + "." + ClassName);
        }
        catch (Exception exception) {
            return C;
        }
    }

    public static Method getMethod(Class<?> Class2, String ClassName, Class<?> ... Parameters) {
        for (Method M : Class2.getMethods()) {
            if (!M.getName().equals(ClassName) || Parameters.length != 0 && !NMSManager.classListEqual(Parameters, M.getParameterTypes())) continue;
            M.setAccessible(true);
            return M;
        }
        return null;
    }

    public static Method getMethod(String MethodName, Class<?> Class2, Class<?> ... Parameters) {
        Class<?>[] T = NMSManager.toPrimitiveTypeArray(Parameters);
        for (Method M : Class2.getMethods()) {
            if (!M.getName().equals(MethodName) || !NMSManager.equalsTypeArray(NMSManager.toPrimitiveTypeArray(M.getParameterTypes()), T)) continue;
            return M;
        }
        return null;
    }

    public static Class<?> getClass(Class<?> Class2, String Search) {
        for (Class<?> C : Class2.getClasses()) {
            if (!C.getSimpleName().equals(Search)) continue;
            return C;
        }
        return null;
    }

    public static Object invokeMethod(String MethodName, Object Parameter2) {
        try {
            return NMSManager.getMethod(MethodName, Parameter2.getClass(), new Class[0]).invoke(Parameter2, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getHandle(Object O) {
        try {
            Method m = O.getClass().getDeclaredMethod("getHandle", new Class[0]);
            m.setAccessible(true);
            return m.invoke(O, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return O;
        }
    }

    public static void sendPacket(Player P, Object Packet) {
        NMSManager.sendPacket(NMSManager.getHandle(P), Packet);
    }

    public static void sendPacket(Object P, Object Packet) {
        try {
            Object p = P.getClass().getField("playerConnection").get(P);
            p.getClass().getMethod("sendPacket", NMSManager.getNMSClass("Packet")).invoke(p, Packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean set(Object Object2, String Field2, Object Value) {
        for (Class<?> C = Object2.getClass(); C != null; C = C.getSuperclass()) {
            try {
                Field F = C.getDeclaredField(Field2);
                F.setAccessible(true);
                F.set(Object2, Value);
                return true;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return false;
    }
}

