/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.events;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.GetUpReason;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.spigotmc.event.entity.EntityDismountEvent;

public class PlayerSitEvents
implements Listener {
    private final GSitMain GPM;

    public PlayerSitEvents(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void PTogSE(PlayerToggleSneakEvent e) {
        Player p = e.getPlayer();
        if (!this.GPM.getCManager().PS_SNEAK_EJECTS || !e.isSneaking() || p.isFlying() || p.isInsideVehicle()) {
            return;
        }
        boolean r = this.GPM.getPlayerSitManager().stopPlayerSit((Entity)p, GetUpReason.KICKED);
        if (!r) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PDeaE(PlayerDeathEvent e) {
        if (e.getEntity().isInsideVehicle()) {
            this.GPM.getPlayerSitManager().stopPlayerSit((Entity)e.getEntity(), GetUpReason.DEATH);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PQuiE(PlayerQuitEvent e) {
        if (e.getPlayer().isInsideVehicle()) {
            this.GPM.getPlayerSitManager().stopPlayerSit((Entity)e.getPlayer(), GetUpReason.QUIT);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void EDisE(EntityDismountEvent e) {
        boolean r = this.GPM.getPlayerSitManager().stopPlayerSit(e.getEntity(), GetUpReason.GET_UP);
        if (!r) {
            e.setCancelled(true);
        }
        this.GPM.getPlayerSitManager().stopPlayerSit(e.getDismounted(), GetUpReason.GET_UP);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void PIntAEE(PlayerInteractAtEntityEvent e) {
        Entity E = e.getRightClicked();
        if (!(E instanceof Player)) {
            return;
        }
        Player p = e.getPlayer();
        Player t = (Player)E;
        if (!this.GPM.getCManager().PS_ALLOW_SIT && !this.GPM.getCManager().PS_ALLOW_SIT_NPC) {
            return;
        }
        if (!this.GPM.getPManager().hasNormalPermission((CommandSender)p, "PlayerSit")) {
            return;
        }
        if (this.GPM.getCManager().WORLDBLACKLIST.contains(p.getWorld().getName()) && !this.GPM.getPManager().hasPermission((CommandSender)p, "ByPass.World", "ByPass.*")) {
            return;
        }
        if (this.GPM.getCManager().PS_EMPTY_HAND_ONLY && p.getInventory().getItemInMainHand().getType() != Material.AIR) {
            return;
        }
        if (!p.isValid() || p.isSneaking() || p.isInsideVehicle() || p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (this.GPM.getCrawlManager() != null && this.GPM.getCrawlManager().isCrawling(p)) {
            return;
        }
        if (this.GPM.getPlotSquared() != null && !this.GPM.getPlotSquared().canCreateSeat(t.getLocation(), p)) {
            return;
        }
        if (this.GPM.getWorldGuard() != null && !this.GPM.getWorldGuard().checkFlag(t.getLocation(), this.GPM.getWorldGuard().PLAYERSIT_FLAG)) {
            return;
        }
        if (this.GPM.getPassengerUtil().isInPassengerList((Entity)t, (Entity)p) || this.GPM.getPassengerUtil().isInPassengerList((Entity)p, (Entity)t)) {
            return;
        }
        long a = this.GPM.getPassengerUtil().getPassengerAmount((Entity)t) + 1L + this.GPM.getPassengerUtil().getVehicleAmount((Entity)t) + this.GPM.getPassengerUtil().getPassengerAmount((Entity)p);
        if (this.GPM.getCManager().PS_MAX_STACK > 0L && this.GPM.getCManager().PS_MAX_STACK <= a) {
            return;
        }
        Entity s = this.GPM.getPassengerUtil().getHighestEntity((Entity)t);
        if (!(s instanceof Player)) {
            return;
        }
        Player z = (Player)s;
        if (!this.GPM.getToggleManager().canPlayerSit(p.getUniqueId()) || !this.GPM.getToggleManager().canPlayerSit(z.getUniqueId())) {
            return;
        }
        boolean n = this.GPM.getPassengerUtil().isNPC(z);
        if (n && !this.GPM.getCManager().PS_ALLOW_SIT_NPC) {
            return;
        }
        if (!n && !this.GPM.getCManager().PS_ALLOW_SIT) {
            return;
        }
        boolean r = this.GPM.getPlayerSitManager().sitOnPlayer(p, z);
        if (r) {
            e.setCancelled(true);
        }
    }
}

