/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.events;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.GetUpReason;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.spigotmc.event.entity.EntityDismountEvent;

public class PlayerEvents
implements Listener {
    private final GSitMain GPM;

    public PlayerEvents(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @EventHandler
    public void PJoiE(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (this.GPM.getCManager().CHECK_FOR_UPDATES && !this.GPM.getUManager().isLatestVersion()) {
            String me = this.GPM.getMManager().getMessage("Plugin.plugin-update", "%Name%", this.GPM.NAME, "%NewVersion%", this.GPM.getUManager().getLatestVersion(), "%Version%", this.GPM.getUManager().getPluginVersion(), "%Path%", this.GPM.getDescription().getWebsite());
            if (this.GPM.getPManager().hasPermission((CommandSender)p, "Update")) {
                p.sendMessage(me);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PQuiE(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        if (this.GPM.getSitManager().isSitting(p)) {
            this.GPM.getSitManager().removeSeat(this.GPM.getSitManager().getSeat(p), GetUpReason.QUIT, true);
        }
        if (this.GPM.getPoseManager() != null && this.GPM.getPoseManager().isPosing(p)) {
            this.GPM.getPoseManager().removePose(this.GPM.getPoseManager().getPose(p), GetUpReason.QUIT, true);
        }
        if (this.GPM.getCrawlManager() != null && this.GPM.getCrawlManager().isCrawling(p)) {
            this.GPM.getCrawlManager().stopCrawl(this.GPM.getCrawlManager().getCrawl(p), GetUpReason.QUIT);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void PTelE(PlayerTeleportEvent e) {
        boolean r;
        Player p = e.getPlayer();
        if (this.GPM.getSitManager().isSitting(p) && !(r = this.GPM.getSitManager().removeSeat(this.GPM.getSitManager().getSeat(p), GetUpReason.TELEPORT, false))) {
            e.setCancelled(true);
        }
        if (this.GPM.getPoseManager() != null && this.GPM.getPoseManager().isPosing(p) && !(r = this.GPM.getPoseManager().removePose(this.GPM.getPoseManager().getPose(p), GetUpReason.TELEPORT, false))) {
            e.setCancelled(true);
        }
        if (this.GPM.getCrawlManager() != null && this.GPM.getCrawlManager().isCrawling(p) && !(r = this.GPM.getCrawlManager().stopCrawl(this.GPM.getCrawlManager().getCrawl(p), GetUpReason.TELEPORT))) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void EDisE(EntityDismountEvent e) {
        boolean r;
        Entity E = e.getEntity();
        if (!(E instanceof Player)) {
            return;
        }
        Player p = (Player)E;
        if (this.GPM.getSitManager().isSitting(p)) {
            if (!this.GPM.getCManager().GET_UP_SNEAK) {
                e.setCancelled(true);
            } else {
                r = this.GPM.getSitManager().removeSeat(this.GPM.getSitManager().getSeat(p), GetUpReason.GET_UP, true);
                if (!r) {
                    e.setCancelled(true);
                }
            }
        }
        if (this.GPM.getPoseManager() != null && this.GPM.getPoseManager().isPosing(p)) {
            if (!this.GPM.getCManager().GET_UP_SNEAK) {
                e.setCancelled(true);
            } else {
                r = this.GPM.getPoseManager().removePose(this.GPM.getPoseManager().getPose(p), GetUpReason.GET_UP, true);
                if (!r) {
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void EDamE(EntityDamageEvent e) {
        Entity E = e.getEntity();
        if (!this.GPM.getCManager().GET_UP_DAMAGE || !(E instanceof Player) || e.getFinalDamage() <= 0.0) {
            return;
        }
        Player p = (Player)E;
        if (this.GPM.getSitManager().isSitting(p)) {
            this.GPM.getSitManager().removeSeat(this.GPM.getSitManager().getSeat(p), GetUpReason.DAMAGE, true);
        }
        if (this.GPM.getPoseManager() != null && this.GPM.getPoseManager().isPosing(p)) {
            this.GPM.getPoseManager().removePose(this.GPM.getPoseManager().getPose(p), GetUpReason.DAMAGE, true);
        }
        if (this.GPM.getCrawlManager() != null && this.GPM.getCrawlManager().isCrawling(p)) {
            this.GPM.getCrawlManager().stopCrawl(this.GPM.getCrawlManager().getCrawl(p), GetUpReason.DAMAGE);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void PComPE(PlayerCommandPreprocessEvent e) {
        Player p = e.getPlayer();
        String m = e.getMessage();
        if (m.length() > 1 && (this.GPM.getSitManager().isSitting(p) || this.GPM.getPoseManager() != null && this.GPM.getPoseManager().isPosing(p))) {
            m = m.substring(1).split(" ")[0].toLowerCase();
            if (this.GPM.getCManager().COMMANDBLACKLIST.stream().anyMatch(m::equalsIgnoreCase)) {
                this.GPM.getMManager().sendMessage((CommandSender)p, "Messages.action-blocked-error", new Object[0]);
                e.setCancelled(true);
            }
        }
    }
}

