/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.events;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.GSeat;
import dev.geco.gsit.objects.GetUpReason;
import dev.geco.gsit.objects.IGPoseSeat;
import java.util.ArrayList;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class BlockEvents
implements Listener {
    private final GSitMain GPM;

    public BlockEvents(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void BPisEE(BlockPistonExtendEvent e) {
        ArrayList<GSeat> ml = new ArrayList<GSeat>();
        for (Block b : e.getBlocks()) {
            if (this.GPM.getSitUtil().isSeatBlock(b)) {
                for (GSeat s : this.GPM.getSitUtil().getSeats(b)) {
                    if (ml.contains(s)) continue;
                    this.GPM.getSitManager().moveSeat(s, e.getDirection());
                    ml.add(s);
                }
            }
            if (!this.GPM.getCManager().GET_UP_BREAK || !this.GPM.getPoseUtil().isPoseBlock(b)) continue;
            for (IGPoseSeat p : this.GPM.getPoseUtil().getPoses(b)) {
                this.GPM.getPoseManager().removePose(p, GetUpReason.BREAK);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void BPisRE(BlockPistonRetractEvent e) {
        ArrayList<GSeat> ml = new ArrayList<GSeat>();
        for (Block b : e.getBlocks()) {
            if (this.GPM.getSitUtil().isSeatBlock(b)) {
                for (GSeat s : this.GPM.getSitUtil().getSeats(b)) {
                    if (ml.contains(s)) continue;
                    this.GPM.getSitManager().moveSeat(s, e.getDirection());
                    ml.add(s);
                }
            }
            if (!this.GPM.getCManager().GET_UP_BREAK || !this.GPM.getPoseUtil().isPoseBlock(b)) continue;
            for (IGPoseSeat p : this.GPM.getPoseUtil().getPoses(b)) {
                this.GPM.getPoseManager().removePose(p, GetUpReason.BREAK);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void BExpE(BlockExplodeEvent e) {
        if (!this.GPM.getCManager().GET_UP_BREAK) {
            return;
        }
        for (Block b : new ArrayList(e.blockList())) {
            boolean r;
            if (this.GPM.getSitUtil().isSeatBlock(b)) {
                for (GSeat s : this.GPM.getSitUtil().getSeats(b)) {
                    r = this.GPM.getSitManager().removeSeat(s, GetUpReason.BREAK);
                    if (r) continue;
                    e.blockList().remove(b);
                }
            }
            if (!this.GPM.getPoseUtil().isPoseBlock(b)) continue;
            for (IGPoseSeat p : this.GPM.getPoseUtil().getPoses(b)) {
                r = this.GPM.getPoseManager().removePose(p, GetUpReason.BREAK);
                if (r) continue;
                e.blockList().remove(b);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void EExpE(EntityExplodeEvent e) {
        if (!this.GPM.getCManager().GET_UP_BREAK) {
            return;
        }
        for (Block b : new ArrayList(e.blockList())) {
            boolean r;
            if (this.GPM.getSitUtil().isSeatBlock(b)) {
                for (GSeat s : this.GPM.getSitUtil().getSeats(b)) {
                    r = this.GPM.getSitManager().removeSeat(s, GetUpReason.BREAK);
                    if (r) continue;
                    e.blockList().remove(b);
                }
            }
            if (!this.GPM.getPoseUtil().isPoseBlock(b)) continue;
            for (IGPoseSeat p : this.GPM.getPoseUtil().getPoses(b)) {
                r = this.GPM.getPoseManager().removePose(p, GetUpReason.BREAK);
                if (r) continue;
                e.blockList().remove(b);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void BFadE(BlockFadeEvent e) {
        boolean r;
        if (!this.GPM.getCManager().GET_UP_BREAK) {
            return;
        }
        if (this.GPM.getSitUtil().isSeatBlock(e.getBlock())) {
            for (GSeat s : this.GPM.getSitUtil().getSeats(e.getBlock())) {
                r = this.GPM.getSitManager().removeSeat(s, GetUpReason.BREAK);
                if (r) continue;
                e.setCancelled(true);
            }
        }
        if (this.GPM.getPoseUtil().isPoseBlock(e.getBlock()) && !e.isCancelled()) {
            for (IGPoseSeat p : this.GPM.getPoseUtil().getPoses(e.getBlock())) {
                r = this.GPM.getPoseManager().removePose(p, GetUpReason.BREAK);
                if (r) continue;
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void LDecE(LeavesDecayEvent e) {
        boolean r;
        if (!this.GPM.getCManager().GET_UP_BREAK) {
            return;
        }
        if (this.GPM.getSitUtil().isSeatBlock(e.getBlock())) {
            for (GSeat s : this.GPM.getSitUtil().getSeats(e.getBlock())) {
                r = this.GPM.getSitManager().removeSeat(s, GetUpReason.BREAK);
                if (r) continue;
                e.setCancelled(true);
            }
        }
        if (this.GPM.getPoseUtil().isPoseBlock(e.getBlock()) && !e.isCancelled()) {
            for (IGPoseSeat p : this.GPM.getPoseUtil().getPoses(e.getBlock())) {
                r = this.GPM.getPoseManager().removePose(p, GetUpReason.BREAK);
                if (r) continue;
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void BBurE(BlockBurnEvent e) {
        boolean r;
        if (!this.GPM.getCManager().GET_UP_BREAK) {
            return;
        }
        if (this.GPM.getSitUtil().isSeatBlock(e.getBlock())) {
            for (GSeat s : this.GPM.getSitUtil().getSeats(e.getBlock())) {
                r = this.GPM.getSitManager().removeSeat(s, GetUpReason.BREAK);
                if (r) continue;
                e.setCancelled(true);
            }
        }
        if (this.GPM.getPoseUtil().isPoseBlock(e.getBlock()) && !e.isCancelled()) {
            for (IGPoseSeat p : this.GPM.getPoseUtil().getPoses(e.getBlock())) {
                r = this.GPM.getPoseManager().removePose(p, GetUpReason.BREAK);
                if (r) continue;
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void EChaBE(EntityChangeBlockEvent e) {
        boolean r;
        if (!this.GPM.getCManager().GET_UP_BREAK) {
            return;
        }
        if (this.GPM.getSitUtil().isSeatBlock(e.getBlock())) {
            for (GSeat s : this.GPM.getSitUtil().getSeats(e.getBlock())) {
                r = this.GPM.getSitManager().removeSeat(s, GetUpReason.BREAK);
                if (r) continue;
                e.setCancelled(true);
            }
        }
        if (this.GPM.getPoseUtil().isPoseBlock(e.getBlock()) && !e.isCancelled()) {
            for (IGPoseSeat p : this.GPM.getPoseUtil().getPoses(e.getBlock())) {
                r = this.GPM.getPoseManager().removePose(p, GetUpReason.BREAK);
                if (r) continue;
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void BBreE(BlockBreakEvent e) {
        boolean r;
        if (!this.GPM.getCManager().GET_UP_BREAK) {
            return;
        }
        if (this.GPM.getSitUtil().isSeatBlock(e.getBlock())) {
            for (GSeat s : this.GPM.getSitUtil().getSeats(e.getBlock())) {
                r = this.GPM.getSitManager().removeSeat(s, GetUpReason.BREAK);
                if (r) continue;
                e.setCancelled(true);
            }
        }
        if (this.GPM.getPoseUtil().isPoseBlock(e.getBlock()) && !e.isCancelled()) {
            for (IGPoseSeat p : this.GPM.getPoseUtil().getPoses(e.getBlock())) {
                r = this.GPM.getPoseManager().removePose(p, GetUpReason.BREAK);
                if (r) continue;
                e.setCancelled(true);
            }
        }
    }
}

