/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit;

import dev.geco.gsit.cmd.GBellyFlopCommand;
import dev.geco.gsit.cmd.GCrawlCommand;
import dev.geco.gsit.cmd.GLayCommand;
import dev.geco.gsit.cmd.GSitCommand;
import dev.geco.gsit.cmd.GSitReloadCommand;
import dev.geco.gsit.cmd.GSpinCommand;
import dev.geco.gsit.cmd.tab.EmptyTabComplete;
import dev.geco.gsit.cmd.tab.GSitTabComplete;
import dev.geco.gsit.events.BlockEvents;
import dev.geco.gsit.events.InteractEvents;
import dev.geco.gsit.events.PlayerEvents;
import dev.geco.gsit.events.PlayerSitEvents;
import dev.geco.gsit.link.BStatsLink;
import dev.geco.gsit.link.PAPILink;
import dev.geco.gsit.link.PlSqLink;
import dev.geco.gsit.link.WoGuLink;
import dev.geco.gsit.manager.CManager;
import dev.geco.gsit.manager.ICrawlManager;
import dev.geco.gsit.manager.IPlayerSitManager;
import dev.geco.gsit.manager.IPoseManager;
import dev.geco.gsit.manager.ISitManager;
import dev.geco.gsit.manager.MManager;
import dev.geco.gsit.manager.NMSManager;
import dev.geco.gsit.manager.PManager;
import dev.geco.gsit.manager.PlayerSitManager;
import dev.geco.gsit.manager.SitManager;
import dev.geco.gsit.manager.ToggleManager;
import dev.geco.gsit.manager.UManager;
import dev.geco.gsit.util.IPlayerUtil;
import dev.geco.gsit.util.ISpawnUtil;
import dev.geco.gsit.util.PassengerUtil;
import dev.geco.gsit.util.PlayerUtil;
import dev.geco.gsit.util.PoseUtil;
import dev.geco.gsit.util.SitUtil;
import dev.geco.gsit.util.SpawnUtil;
import java.io.File;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GSitMain
extends JavaPlugin {
    private FileConfiguration messages;
    private CManager cmanager;
    private String prefix;
    private ISitManager sitmanager;
    private IPoseManager posemanager;
    private IPlayerSitManager playersitmanager;
    private ICrawlManager crawlmanager;
    private ToggleManager togglemanager;
    private UManager umanager;
    private PManager pmanager;
    private MManager mmanager;
    private PassengerUtil passengerutil;
    private SitUtil situtil;
    private PoseUtil poseutil;
    private ISpawnUtil spawnutil;
    private IPlayerUtil playerutil;
    private PAPILink papilink;
    private PlSqLink plsqlink;
    private WoGuLink wogulink;
    public final String NAME = "GSit";
    public final String RESOURCE = "62325";
    private static GSitMain GPM;

    public FileConfiguration getMessages() {
        return this.messages;
    }

    public CManager getCManager() {
        return this.cmanager;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ISitManager getSitManager() {
        return this.sitmanager;
    }

    public IPoseManager getPoseManager() {
        return this.posemanager;
    }

    public IPlayerSitManager getPlayerSitManager() {
        return this.playersitmanager;
    }

    public ICrawlManager getCrawlManager() {
        return this.crawlmanager;
    }

    public ToggleManager getToggleManager() {
        return this.togglemanager;
    }

    public UManager getUManager() {
        return this.umanager;
    }

    public PManager getPManager() {
        return this.pmanager;
    }

    public MManager getMManager() {
        return this.mmanager;
    }

    public PassengerUtil getPassengerUtil() {
        return this.passengerutil;
    }

    public SitUtil getSitUtil() {
        return this.situtil;
    }

    public PoseUtil getPoseUtil() {
        return this.poseutil;
    }

    public ISpawnUtil getSpawnUtil() {
        return this.spawnutil;
    }

    public IPlayerUtil getPlayerUtil() {
        return this.playerutil;
    }

    public PAPILink getPlaceholderAPI() {
        return this.papilink;
    }

    public PlSqLink getPlotSquared() {
        return this.plsqlink;
    }

    public WoGuLink getWorldGuard() {
        return this.wogulink;
    }

    public static GSitMain getInstance() {
        return GPM;
    }

    private void loadSettings() {
        this.copyLangFiles();
        this.messages = YamlConfiguration.loadConfiguration((File)new File("plugins/GSit/lang", this.getConfig().getString("Lang.lang", "en_en") + ".yml"));
        this.prefix = this.getMessages().getString("Plugin.plugin-prefix");
        this.getToggleManager().loadToggleData();
    }

    private void linkBStats() {
        BStatsLink bstats = new BStatsLink(GSitMain.getInstance(), 4914);
        bstats.addCustomChart(new BStatsLink.SimplePie("plugin_language", () -> this.getConfig().getString("Lang.lang", "en_en").toLowerCase()));
        bstats.addCustomChart(new BStatsLink.SingleLineChart("use_sit_feature", () -> {
            if (this.getSitManager() == null) {
                return 0;
            }
            int c = this.getSitManager().getFeatureUsedCount();
            this.getSitManager().resetFeatureUsedCount();
            return c;
        }));
        bstats.addCustomChart(new BStatsLink.SingleLineChart("use_pose_feature", () -> {
            if (this.getPoseManager() == null) {
                return 0;
            }
            int c = this.getPoseManager().getFeatureUsedCount();
            this.getPoseManager().resetFeatureUsedCount();
            return c;
        }));
        bstats.addCustomChart(new BStatsLink.SingleLineChart("use_psit_feature", () -> {
            if (this.getPlayerSitManager() == null) {
                return 0;
            }
            int c = this.getPlayerSitManager().getFeatureUsedCount();
            this.getPlayerSitManager().resetFeatureUsedCount();
            return c;
        }));
        bstats.addCustomChart(new BStatsLink.SingleLineChart("use_crawl_feature", () -> {
            if (this.getCrawlManager() == null) {
                return 0;
            }
            int c = this.getCrawlManager().getFeatureUsedCount();
            this.getCrawlManager().resetFeatureUsedCount();
            return c;
        }));
    }

    public void onLoad() {
        GPM = this;
        this.saveDefaultConfig();
        this.cmanager = new CManager(GSitMain.getInstance());
        this.umanager = new UManager((Plugin)GSitMain.getInstance(), "62325");
        this.pmanager = new PManager(GSitMain.getInstance());
        this.mmanager = new MManager(GSitMain.getInstance());
        this.sitmanager = new SitManager(GSitMain.getInstance());
        this.playersitmanager = new PlayerSitManager(GSitMain.getInstance());
        this.togglemanager = new ToggleManager(GSitMain.getInstance());
        this.passengerutil = new PassengerUtil(GSitMain.getInstance());
        this.situtil = new SitUtil(GSitMain.getInstance());
        this.poseutil = new PoseUtil(GSitMain.getInstance());
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            this.wogulink = new WoGuLink(GSitMain.getInstance());
            this.wogulink.registerFlags();
        }
    }

    public void onEnable() {
        if (!this.versionCheck()) {
            return;
        }
        this.posemanager = NMSManager.isNewerOrVersion(17L, 0) ? (IPoseManager)NMSManager.getPackageObject("gsit", "manager.PoseManager", (Object)GSitMain.getInstance()) : null;
        this.crawlmanager = NMSManager.isNewerOrVersion(17L, 0) ? (ICrawlManager)NMSManager.getPackageObject("gsit", "manager.CrawlManager", (Object)GSitMain.getInstance()) : null;
        this.spawnutil = NMSManager.isNewerOrVersion(17L, 0) ? (ISpawnUtil)NMSManager.getPackageObject("gsit", "util.SpawnUtil", null) : new SpawnUtil();
        this.playerutil = NMSManager.isNewerOrVersion(17L, 0) ? (IPlayerUtil)NMSManager.getPackageObject("gsit", "util.PlayerUtil", null) : new PlayerUtil();
        this.setupCommands();
        this.setupEvents();
        this.loadSettings();
        this.linkBStats();
        this.getMManager().sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-enabled", new Object[0]);
        this.loadPluginDepends((CommandSender)Bukkit.getConsoleSender());
        this.checkForUpdates();
    }

    public void onDisable() {
        this.getSitManager().clearSeats();
        if (this.getPoseManager() != null) {
            this.getPoseManager().clearPoses();
        }
        if (this.getCrawlManager() != null) {
            this.getCrawlManager().clearCrawls();
        }
        this.getToggleManager().saveToggleData();
        if (this.getPlaceholderAPI() != null) {
            this.getPlaceholderAPI().unregister();
        }
        this.getMManager().sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-disabled", new Object[0]);
    }

    private void setupCommands() {
        this.getCommand("gsit").setExecutor((CommandExecutor)new GSitCommand(GSitMain.getInstance()));
        this.getCommand("gsit").setTabCompleter((TabCompleter)new GSitTabComplete(GSitMain.getInstance()));
        this.getCommand("glay").setExecutor((CommandExecutor)new GLayCommand(GSitMain.getInstance()));
        this.getCommand("glay").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("gbellyflop").setExecutor((CommandExecutor)new GBellyFlopCommand(GSitMain.getInstance()));
        this.getCommand("gbellyflop").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("gspin").setExecutor((CommandExecutor)new GSpinCommand(GSitMain.getInstance()));
        this.getCommand("gspin").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("gcrawl").setExecutor((CommandExecutor)new GCrawlCommand(GSitMain.getInstance()));
        this.getCommand("gcrawl").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("gsitreload").setExecutor((CommandExecutor)new GSitReloadCommand(GSitMain.getInstance()));
        this.getCommand("gsitreload").setTabCompleter((TabCompleter)new EmptyTabComplete());
    }

    private void setupEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEvents(GSitMain.getInstance()), (Plugin)GSitMain.getInstance());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerSitEvents(GSitMain.getInstance()), (Plugin)GSitMain.getInstance());
        this.getServer().getPluginManager().registerEvents((Listener)new BlockEvents(GSitMain.getInstance()), (Plugin)GSitMain.getInstance());
        this.getServer().getPluginManager().registerEvents((Listener)new InteractEvents(GSitMain.getInstance()), (Plugin)GSitMain.getInstance());
    }

    private void loadPluginDepends(CommandSender s) {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null && Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.papilink = new PAPILink(GSitMain.getInstance());
            this.getMManager().sendMessage(s, "Plugin.plugin-link", "%Link%", "PlaceholderAPI");
            this.getPlaceholderAPI().register();
        } else {
            this.papilink = null;
        }
        if (Bukkit.getPluginManager().getPlugin("PlotSquared") != null && Bukkit.getPluginManager().isPluginEnabled("PlotSquared")) {
            this.plsqlink = new PlSqLink(GSitMain.getInstance());
            if (this.getPlotSquared().isVersionSupported()) {
                this.getMManager().sendMessage(s, "Plugin.plugin-link", "%Link%", "PlotSquared");
            } else {
                this.plsqlink = null;
            }
        } else {
            this.plsqlink = null;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && Bukkit.getPluginManager().isPluginEnabled("WorldGuard")) {
            if (this.wogulink == null) {
                this.wogulink = new WoGuLink(GSitMain.getInstance());
                this.getWorldGuard().registerFlags();
            }
            this.getMManager().sendMessage(s, "Plugin.plugin-link", "%Link%", "WorldGuard");
        } else {
            this.wogulink = null;
        }
    }

    private void copyLangFiles() {
        for (String l : Arrays.asList("de_de", "en_en", "es_es", "fi_fi", "fr_fr", "it_it", "pl_pl", "pt_br", "ru_ru", "uk_ua", "zh_cn", "zh_tw")) {
            if (new File("plugins/GSit/lang/" + l + ".yml").exists()) continue;
            this.saveResource("lang/" + l + ".yml", false);
        }
    }

    public void reload(CommandSender s) {
        this.reloadConfig();
        this.getCManager().reload();
        this.getSitManager().clearSeats();
        if (this.getPoseManager() != null) {
            this.getPoseManager().clearPoses();
        }
        if (this.getCrawlManager() != null) {
            this.getCrawlManager().clearCrawls();
        }
        this.getToggleManager().saveToggleData();
        if (this.getPlaceholderAPI() != null) {
            this.getPlaceholderAPI().unregister();
        }
        this.loadSettings();
        this.loadPluginDepends(s);
        this.checkForUpdates();
    }

    private void checkForUpdates() {
        if (this.getCManager().CHECK_FOR_UPDATES) {
            this.getUManager().checkVersion();
            if (!this.getUManager().isLatestVersion()) {
                String me = this.getMManager().getMessage("Plugin.plugin-update", "%Name%", "GSit", "%NewVersion%", this.getUManager().getLatestVersion(), "%Version%", this.getUManager().getPluginVersion(), "%Path%", this.getDescription().getWebsite());
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!this.getPManager().hasPermission((CommandSender)p, "Update")) continue;
                    p.sendMessage(me);
                }
                Bukkit.getConsoleSender().sendMessage(me);
            }
        }
    }

    private boolean versionCheck() {
        if (!NMSManager.isNewerOrVersion(13L, 0) || NMSManager.isNewerOrVersion(17L, 0) && NMSManager.getPackageObject("gsit", "manager.PoseManager", (Object)GSitMain.getInstance()) == null) {
            String v = Bukkit.getServer().getClass().getPackage().getName();
            this.getMManager().sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-version", "%Version%", v.substring(v.lastIndexOf(46) + 1));
            this.checkForUpdates();
            Bukkit.getPluginManager().disablePlugin((Plugin)GSitMain.getInstance());
            return false;
        }
        return true;
    }
}

